/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import io.papermc.paper.util.OldEnumHolderable;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftBiome
extends OldEnumHolderable<Biome, net.minecraft.world.level.biome.Biome>
implements Biome {
    private static int count = 0;

    public static Biome minecraftToBukkit(net.minecraft.world.level.biome.Biome minecraft) {
        return (Biome)CraftRegistry.minecraftToBukkit(minecraft, Registries.BIOME);
    }

    public static Biome minecraftHolderToBukkit(Holder<net.minecraft.world.level.biome.Biome> minecraft) {
        return (Biome)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.BIOME);
    }

    public static @Nullable net.minecraft.world.level.biome.Biome bukkitToMinecraft(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return (net.minecraft.world.level.biome.Biome)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static @Nullable Holder<net.minecraft.world.level.biome.Biome> bukkitToMinecraftHolder(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.BIOME);
    }

    public CraftBiome(Holder<net.minecraft.world.level.biome.Biome> holder) {
        super(holder, count++);
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static class LegacyCustomBiomeImpl
    implements Biome {
        private static final NamespacedKey LEGACY_CUSTOM_KEY = new NamespacedKey("minecraft", "custom");
        private final int ordinal = count++;

        @NotNull
        public NamespacedKey getKey() {
            return LEGACY_CUSTOM_KEY;
        }

        public int compareTo(@NotNull Biome other) {
            return this.ordinal - other.ordinal();
        }

        @NotNull
        public String name() {
            return "CUSTOM";
        }

        public int ordinal() {
            return this.ordinal;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LegacyCustomBiomeImpl that = (LegacyCustomBiomeImpl)object;
            return this.ordinal == that.ordinal;
        }

        public int hashCode() {
            return Objects.hashCode(this.ordinal);
        }

        public String toString() {
            return "CUSTOM";
        }
    }
}

