/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.SculkCatalyst;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.jetbrains.annotations.NotNull;

public class CraftSculkCatalyst
extends CraftBlockEntityState<SculkCatalystBlockEntity>
implements SculkCatalyst {
    public CraftSculkCatalyst(World world, SculkCatalystBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftSculkCatalyst(CraftSculkCatalyst state, Location location) {
        super(state, location);
    }

    public void bloom(Block block, int charge) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block cannot be null");
        Preconditions.checkArgument((charge > 0 ? 1 : 0) != 0, (Object)"charge must be positive");
        this.requirePlaced();
        ((SculkCatalystBlockEntity)this.getBlockEntity()).getListener().bloom(this.world.getHandle(), this.getPosition(), this.getHandle(), this.world.getHandle().getRandom());
        ((SculkCatalystBlockEntity)this.getBlockEntity()).getListener().getSculkSpreader().addCursors(new BlockPos(block.getX(), block.getY(), block.getZ()), charge);
    }

    @Override
    public CraftSculkCatalyst copy() {
        return new CraftSculkCatalyst(this, null);
    }

    @Override
    public CraftSculkCatalyst copy(Location location) {
        return new CraftSculkCatalyst(this, location);
    }

    public void bloom(@NotNull Position position, int charge) {
        Preconditions.checkNotNull((Object)position);
        this.requirePlaced();
        ((SculkCatalystBlockEntity)this.getBlockEntity()).getListener().bloom(this.world.getHandle(), ((SculkCatalystBlockEntity)this.getBlockEntity()).getBlockPos(), ((SculkCatalystBlockEntity)this.getBlockEntity()).getBlockState(), this.world.getHandle().getRandom());
        ((SculkCatalystBlockEntity)this.getBlockEntity()).getListener().getSculkSpreader().addCursors(MCUtil.toBlockPos(position), charge);
    }
}

