/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.generated.GeneratedFrom;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Rotatable;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.util.Vector;

@GeneratedFrom(value="1.21.5")
public class CraftBanner
extends CraftBlockData
implements Rotatable {
    private static final IntegerProperty ROTATION = BannerBlock.ROTATION;

    public CraftBanner(BlockState state) {
        super(state);
    }

    public BlockFace getRotation() {
        return CraftBlockData.ROTATION_CYCLE[this.get(ROTATION)];
    }

    public void setRotation(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace != BlockFace.SELF && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only horizontal face are allowed for this property!");
        Vector dir = blockFace.getDirection();
        float angle = (float)(-Math.toDegrees(Math.atan2(dir.getX(), dir.getZ())));
        this.set(ROTATION, RotationSegment.convertToSegment(angle));
    }
}

