/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.generated.GeneratedFrom;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Cocoa;
import org.bukkit.craftbukkit.block.data.CraftBlockData;

@GeneratedFrom(value="1.21.5")
public class CraftCocoa
extends CraftBlockData
implements Cocoa {
    private static final IntegerProperty AGE = CocoaBlock.AGE;
    private static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public CraftCocoa(BlockState state) {
        super(state);
    }

    public int getAge() {
        return this.get(AGE);
    }

    public void setAge(int age) {
        this.set(AGE, age);
    }

    public int getMaximumAge() {
        return CraftCocoa.AGE.max;
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }
}

