/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.generated.GeneratedFrom;
import java.util.Set;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.type.RedstoneRail;
import org.bukkit.craftbukkit.block.data.CraftBlockData;

@GeneratedFrom(value="1.21.5")
public class CraftDetectorRail
extends CraftBlockData
implements RedstoneRail {
    private static final BooleanProperty POWERED = DetectorRailBlock.POWERED;
    private static final EnumProperty<RailShape> SHAPE = DetectorRailBlock.SHAPE;
    private static final BooleanProperty WATERLOGGED = BaseRailBlock.WATERLOGGED;

    public CraftDetectorRail(BlockState state) {
        super(state);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }

    public Rail.Shape getShape() {
        return this.get(SHAPE, Rail.Shape.class);
    }

    public void setShape(Rail.Shape shape) {
        Preconditions.checkArgument((shape != null ? 1 : 0) != 0, (Object)"shape cannot be null!");
        Preconditions.checkArgument((shape != Rail.Shape.NORTH_EAST && shape != Rail.Shape.NORTH_WEST && shape != Rail.Shape.SOUTH_EAST && shape != Rail.Shape.SOUTH_WEST ? 1 : 0) != 0, (Object)"Invalid rail shape, only straight rail are allowed for this property!");
        this.set(SHAPE, shape);
    }

    public Set<Rail.Shape> getShapes() {
        return this.getValues(SHAPE, Rail.Shape.class);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

