/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.generated.GeneratedFrom;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.MossyCarpet;
import org.bukkit.block.data.type.Wall;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;

@GeneratedFrom(value="1.21.5")
public class CraftMossyCarpet
extends CraftBlockData
implements MossyCarpet {
    private static final BooleanProperty BASE = MossyCarpetBlock.BASE;
    private static final Map<BlockFace, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = MossyCarpetBlock.PROPERTY_BY_DIRECTION.entrySet().stream().collect(Collectors.toMap(entry -> CraftBlock.notchToBlockFace((Direction)entry.getKey()), entry -> (EnumProperty)entry.getValue()));

    public CraftMossyCarpet(BlockState state) {
        super(state);
    }

    public boolean isBottom() {
        return this.get(BASE);
    }

    public void setBottom(boolean bottom) {
        this.set(BASE, bottom);
    }

    public Wall.Height getHeight(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        EnumProperty<WallSide> property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        return this.get(property, Wall.Height.class);
    }

    public void setHeight(BlockFace blockFace, Wall.Height height) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((height != null ? 1 : 0) != 0, (Object)"height cannot be null!");
        EnumProperty<WallSide> property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        this.set(property, height);
    }
}

