/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.generated.GeneratedFrom;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.craftbukkit.block.data.CraftBlockData;

@GeneratedFrom(value="1.21.5")
public class CraftPointedDripstone
extends CraftBlockData
implements PointedDripstone {
    private static final EnumProperty<DripstoneThickness> THICKNESS = PointedDripstoneBlock.THICKNESS;
    private static final EnumProperty<Direction> TIP_DIRECTION = PointedDripstoneBlock.TIP_DIRECTION;
    private static final BooleanProperty WATERLOGGED = PointedDripstoneBlock.WATERLOGGED;

    public CraftPointedDripstone(BlockState state) {
        super(state);
    }

    public PointedDripstone.Thickness getThickness() {
        return this.get(THICKNESS, PointedDripstone.Thickness.class);
    }

    public void setThickness(PointedDripstone.Thickness thickness) {
        Preconditions.checkArgument((thickness != null ? 1 : 0) != 0, (Object)"thickness cannot be null!");
        this.set(THICKNESS, thickness);
    }

    public BlockFace getVerticalDirection() {
        return this.get(TIP_DIRECTION, BlockFace.class);
    }

    public void setVerticalDirection(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.getModY() != 0 ? 1 : 0) != 0, (Object)"Invalid face, only vertical face are allowed for this property!");
        this.set(TIP_DIRECTION, blockFace);
    }

    public Set<BlockFace> getVerticalDirections() {
        return this.getValues(TIP_DIRECTION, BlockFace.class);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

