/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class CraftBossBar
implements BossBar {
    private final ServerBossEvent handle;
    private Map<BarFlag, FlagContainer> flags;

    public CraftBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.handle = new ServerBossEvent(CraftChatMessage.fromString(title, true)[0], this.convertColor(color), this.convertStyle(style));
        this.initialize();
        for (BarFlag flag : flags) {
            this.addFlag(flag);
        }
        this.setColor(color);
        this.setStyle(style);
    }

    public CraftBossBar(ServerBossEvent bossBattleServer) {
        this.handle = bossBattleServer;
        this.initialize();
    }

    private void initialize() {
        this.flags = new HashMap<BarFlag, FlagContainer>();
        this.flags.put(BarFlag.DARKEN_SKY, new FlagContainer(this, this.handle::shouldDarkenScreen, this.handle::setDarkenScreen));
        this.flags.put(BarFlag.PLAY_BOSS_MUSIC, new FlagContainer(this, this.handle::shouldPlayBossMusic, this.handle::setPlayBossMusic));
        this.flags.put(BarFlag.CREATE_FOG, new FlagContainer(this, this.handle::shouldCreateWorldFog, this.handle::setCreateWorldFog));
    }

    private BarColor convertColor(BossEvent.BossBarColor color) {
        return BarColor.valueOf((String)color.name());
    }

    private BossEvent.BossBarColor convertColor(BarColor color) {
        return BossEvent.BossBarColor.valueOf(color.name());
    }

    private BossEvent.BossBarOverlay convertStyle(BarStyle style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case BarStyle.SOLID -> BossEvent.BossBarOverlay.PROGRESS;
            case BarStyle.SEGMENTED_6 -> BossEvent.BossBarOverlay.NOTCHED_6;
            case BarStyle.SEGMENTED_10 -> BossEvent.BossBarOverlay.NOTCHED_10;
            case BarStyle.SEGMENTED_12 -> BossEvent.BossBarOverlay.NOTCHED_12;
            case BarStyle.SEGMENTED_20 -> BossEvent.BossBarOverlay.NOTCHED_20;
        };
    }

    private BarStyle convertStyle(BossEvent.BossBarOverlay style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case BossEvent.BossBarOverlay.PROGRESS -> BarStyle.SOLID;
            case BossEvent.BossBarOverlay.NOTCHED_6 -> BarStyle.SEGMENTED_6;
            case BossEvent.BossBarOverlay.NOTCHED_10 -> BarStyle.SEGMENTED_10;
            case BossEvent.BossBarOverlay.NOTCHED_12 -> BarStyle.SEGMENTED_12;
            case BossEvent.BossBarOverlay.NOTCHED_20 -> BarStyle.SEGMENTED_20;
        };
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.handle.name);
    }

    public void setTitle(String title) {
        this.handle.name = CraftChatMessage.fromString(title, true)[0];
        this.handle.broadcast(ClientboundBossEventPacket::createUpdateNamePacket);
    }

    public BarColor getColor() {
        return this.convertColor(this.handle.color);
    }

    public void setColor(BarColor color) {
        this.handle.color = this.convertColor(color);
        this.handle.broadcast(ClientboundBossEventPacket::createUpdateStylePacket);
    }

    public BarStyle getStyle() {
        return this.convertStyle(this.handle.overlay);
    }

    public void setStyle(BarStyle style) {
        this.handle.overlay = this.convertStyle(style);
        this.handle.broadcast(ClientboundBossEventPacket::createUpdateStylePacket);
    }

    public void addFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(true);
        }
    }

    public void removeFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(false);
        }
    }

    public boolean hasFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            return flagContainer.get.get();
        }
        return false;
    }

    public void setProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (String)"Progress must be between 0.0 and 1.0 (%s)", (Object)progress);
        this.handle.setProgress((float)progress);
    }

    public double getProgress() {
        return this.handle.getProgress();
    }

    public void addPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        Preconditions.checkArgument((((CraftPlayer)player).getHandle().connection != null ? 1 : 0) != 0, (Object)"player is not fully connected (wait for PlayerJoinEvent)");
        this.handle.addPlayer(((CraftPlayer)player).getHandle());
    }

    public void removePlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        this.handle.removePlayer(((CraftPlayer)player).getHandle());
    }

    public List<Player> getPlayers() {
        ImmutableList.Builder players = ImmutableList.builder();
        for (ServerPlayer p : this.handle.getPlayers()) {
            players.add((Object)p.getBukkitEntity());
        }
        return players.build();
    }

    public void setVisible(boolean visible) {
        this.handle.setVisible(visible);
    }

    public boolean isVisible() {
        return this.handle.visible;
    }

    public void show() {
        this.handle.setVisible(true);
    }

    public void hide() {
        this.handle.setVisible(false);
    }

    public void removeAll() {
        for (Player player : this.getPlayers()) {
            this.removePlayer(player);
        }
    }

    public ServerBossEvent getHandle() {
        return this.handle;
    }

    private final class FlagContainer {
        private final Supplier<Boolean> get;
        private final Consumer<Boolean> set;

        private FlagContainer(CraftBossBar craftBossBar, Supplier<Boolean> get, Consumer<Boolean> set) {
            this.get = get;
            this.set = set;
        }
    }
}

