/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import java.util.UUID;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public abstract class AbstractProjectile
extends CraftEntity
implements Projectile {
    public AbstractProjectile(CraftServer server, net.minecraft.world.entity.Entity entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile getHandle() {
        return (net.minecraft.world.entity.projectile.Projectile)this.entity;
    }

    public boolean doesBounce() {
        return false;
    }

    public void setBounce(boolean doesBounce) {
    }

    public boolean hasLeftShooter() {
        return this.getHandle().leftOwner;
    }

    public void setHasLeftShooter(boolean leftShooter) {
        this.getHandle().leftOwner = leftShooter;
    }

    public boolean hasBeenShot() {
        return this.getHandle().hasBeenShot;
    }

    public void setHasBeenShot(boolean beenShot) {
        this.getHandle().hasBeenShot = beenShot;
    }

    public boolean canHitEntity(Entity entity) {
        return this.getHandle().canHitEntityPublic(((CraftEntity)entity).getHandle());
    }

    public void hitEntity(Entity entity) {
        this.getHandle().preHitTargetOrDeflectSelf(new EntityHitResult(((CraftEntity)entity).getHandle()));
    }

    public void hitEntity(Entity entity, Vector vector) {
        this.getHandle().preHitTargetOrDeflectSelf(new EntityHitResult(((CraftEntity)entity).getHandle(), new Vec3(vector.getX(), vector.getY(), vector.getZ())));
    }

    public final ProjectileSource getShooter() {
        this.getHandle().refreshProjectileSource(true);
        return this.getHandle().projectileSource;
    }

    public final void setShooter(ProjectileSource shooter) {
        if (shooter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)shooter;
            this.getHandle().setOwner(craftEntity.getHandle());
        } else {
            this.getHandle().setOwner(null);
        }
        this.getHandle().projectileSource = shooter;
    }

    public UUID getOwnerUniqueId() {
        return this.getHandle().ownerUUID;
    }
}

