/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.allay.Allay;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftCreature;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.inventory.Inventory;

public class CraftAllay
extends CraftCreature
implements org.bukkit.entity.Allay {
    public CraftAllay(CraftServer server, Allay entity) {
        super(server, entity);
    }

    @Override
    public Allay getHandle() {
        return (Allay)this.entity;
    }

    public Inventory getInventory() {
        return new CraftInventory(this.getHandle().getInventory());
    }

    public boolean canDuplicate() {
        return this.getHandle().canDuplicate();
    }

    public void setCanDuplicate(boolean canDuplicate) {
        this.getHandle().setCanDuplicate(canDuplicate);
    }

    public long getDuplicationCooldown() {
        return this.getHandle().duplicationCooldown;
    }

    public void setDuplicationCooldown(long l) {
        this.getHandle().duplicationCooldown = l;
    }

    public void resetDuplicationCooldown() {
        this.getHandle().resetDuplicationCooldown();
    }

    public boolean isDancing() {
        return this.getHandle().isDancing();
    }

    public void startDancing(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)location.getBlock().getType().equals((Object)Material.JUKEBOX), (Object)"The Block in the Location need to be a JukeBox");
        this.getHandle().setJukeboxPlaying(CraftLocation.toBlockPosition(location), true);
    }

    public void startDancing() {
        this.getHandle().forceDancing = true;
        this.getHandle().setDancing(true);
    }

    public void stopDancing() {
        this.getHandle().forceDancing = false;
        this.getHandle().jukeboxPos = null;
        this.getHandle().setDancing(false);
    }

    public org.bukkit.entity.Allay duplicateAllay() {
        Allay nmsAllay = this.getHandle().duplicateAllay();
        return nmsAllay != null ? (org.bukkit.entity.Allay)nmsAllay.getBukkitEntity() : null;
    }

    public Location getJukebox() {
        BlockPos nmsJukeboxPos = this.getHandle().jukeboxPos;
        return nmsJukeboxPos != null ? CraftLocation.toBukkit(nmsJukeboxPos, this.getWorld()) : null;
    }
}

