/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.entity.Armadillo;

public class CraftArmadillo
extends CraftAnimals
implements org.bukkit.entity.Armadillo {
    public CraftArmadillo(CraftServer server, Armadillo entity) {
        super(server, entity);
    }

    @Override
    public Armadillo getHandle() {
        return (Armadillo)this.entity;
    }

    public Armadillo.State getState() {
        return CraftArmadillo.stateToBukkit(this.getHandle().getState());
    }

    public void rollUp() {
        this.getHandle().getBrain().setMemoryWithExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY, true, 80L);
        this.getHandle().rollUp();
    }

    public void rollOut() {
        if (this.getHandle().getBrain().getTimeUntilExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY) <= (long)Armadillo.ArmadilloState.UNROLLING.animationDuration()) {
            return;
        }
        this.getHandle().lastHurtByMob = null;
        this.getHandle().getBrain().setMemoryWithExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY, true, Armadillo.ArmadilloState.UNROLLING.animationDuration());
    }

    public static Armadillo.State stateToBukkit(Armadillo.ArmadilloState state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Armadillo.ArmadilloState.IDLE -> Armadillo.State.IDLE;
            case Armadillo.ArmadilloState.ROLLING -> Armadillo.State.ROLLING;
            case Armadillo.ArmadilloState.SCARED -> Armadillo.State.SCARED;
            case Armadillo.ArmadilloState.UNROLLING -> Armadillo.State.UNROLLING;
        };
    }

    public static Armadillo.ArmadilloState stateToNMS(Armadillo.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Armadillo.State.IDLE -> Armadillo.ArmadilloState.IDLE;
            case Armadillo.State.ROLLING -> Armadillo.ArmadilloState.ROLLING;
            case Armadillo.State.SCARED -> Armadillo.ArmadilloState.SCARED;
            case Armadillo.State.UNROLLING -> Armadillo.ArmadilloState.UNROLLING;
        };
    }
}

