/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Bee;

public class CraftBee
extends CraftAnimals
implements Bee {
    public CraftBee(CraftServer server, net.minecraft.world.entity.animal.Bee entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.animal.Bee getHandle() {
        return (net.minecraft.world.entity.animal.Bee)this.entity;
    }

    public Location getHive() {
        BlockPos hive = this.getHandle().getHivePos();
        return hive == null ? null : CraftLocation.toBukkit(hive, this.getWorld());
    }

    public void setHive(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals((Object)location.getWorld()) ? 1 : 0) != 0, (Object)"Hive must be in same world");
        this.getHandle().hivePos = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    public Location getFlower() {
        BlockPos flower = this.getHandle().getSavedFlowerPos();
        return flower == null ? null : CraftLocation.toBukkit(flower, this.getWorld());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals((Object)location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        this.getHandle().setSavedFlowerPos(location == null ? null : CraftLocation.toBlockPosition(location));
    }

    public boolean hasNectar() {
        return this.getHandle().hasNectar();
    }

    public void setHasNectar(boolean nectar) {
        this.getHandle().setHasNectar(nectar);
    }

    public boolean hasStung() {
        return this.getHandle().hasStung();
    }

    public void setHasStung(boolean stung) {
        this.getHandle().setHasStung(stung);
    }

    public int getAnger() {
        return this.getHandle().getRemainingPersistentAngerTime();
    }

    public void setAnger(int anger) {
        this.getHandle().setRemainingPersistentAngerTime(anger);
    }

    public int getCannotEnterHiveTicks() {
        return this.getHandle().stayOutOfHiveCountdown;
    }

    public void setCannotEnterHiveTicks(int ticks) {
        this.getHandle().setStayOutOfHiveCountdown(ticks);
    }

    public void setRollingOverride(TriState rolling) {
        this.getHandle().rollingOverride = rolling;
        this.getHandle().setRolling(this.getHandle().isRolling());
    }

    public boolean isRolling() {
        return this.getRollingOverride().toBooleanOrElse(this.getHandle().isRolling());
    }

    public TriState getRollingOverride() {
        return this.getHandle().rollingOverride;
    }

    public void setCropsGrownSincePollination(int crops) {
        this.getHandle().numCropsGrownSincePollination = crops;
    }

    public int getCropsGrownSincePollination() {
        return this.getHandle().numCropsGrownSincePollination;
    }

    public void setTicksSincePollination(int ticks) {
        this.getHandle().ticksWithoutNectarSinceExitingHive = ticks;
    }

    public int getTicksSincePollination() {
        return this.getHandle().ticksWithoutNectarSinceExitingHive;
    }
}

