/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import io.papermc.paper.entity.PaperLeashable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftVehicle;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.entity.Boat;

public abstract class CraftBoat
extends CraftVehicle
implements Boat,
PaperLeashable {
    public CraftBoat(CraftServer server, AbstractBoat entity) {
        super(server, entity);
    }

    @Override
    public AbstractBoat getHandle() {
        return (AbstractBoat)this.entity;
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().getType());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().getType());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Material getBoatMaterial() {
        return CraftMagicNumbers.getMaterial(this.getHandle().getDropItem());
    }

    public Boat.Status getStatus() {
        AbstractBoat handle = this.getHandle();
        if (handle.status == null) {
            if (handle.valid) {
                return CraftBoat.boatStatusFromNms(handle.getStatus());
            }
            return Boat.Status.NOT_IN_WORLD;
        }
        return CraftBoat.boatStatusFromNms(this.getHandle().status);
    }

    public static Boat.Type boatTypeFromNms(EntityType<?> boatType) {
        if (boatType == EntityType.OAK_BOAT || boatType == EntityType.OAK_CHEST_BOAT) {
            return Boat.Type.OAK;
        }
        if (boatType == EntityType.BIRCH_BOAT || boatType == EntityType.BIRCH_CHEST_BOAT) {
            return Boat.Type.BIRCH;
        }
        if (boatType == EntityType.ACACIA_BOAT || boatType == EntityType.ACACIA_CHEST_BOAT) {
            return Boat.Type.ACACIA;
        }
        if (boatType == EntityType.CHERRY_BOAT || boatType == EntityType.CHERRY_CHEST_BOAT) {
            return Boat.Type.CHERRY;
        }
        if (boatType == EntityType.JUNGLE_BOAT || boatType == EntityType.JUNGLE_CHEST_BOAT) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == EntityType.SPRUCE_BOAT || boatType == EntityType.SPRUCE_CHEST_BOAT) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == EntityType.DARK_OAK_BOAT || boatType == EntityType.DARK_OAK_CHEST_BOAT) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == EntityType.MANGROVE_BOAT || boatType == EntityType.MANGROVE_CHEST_BOAT) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == EntityType.BAMBOO_RAFT || boatType == EntityType.BAMBOO_CHEST_RAFT) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(AbstractBoat.Status enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case AbstractBoat.Status.IN_AIR -> Boat.Status.IN_AIR;
            case AbstractBoat.Status.ON_LAND -> Boat.Status.ON_LAND;
            case AbstractBoat.Status.UNDER_WATER -> Boat.Status.UNDER_WATER;
            case AbstractBoat.Status.UNDER_FLOWING_WATER -> Boat.Status.UNDER_FLOWING_WATER;
            case AbstractBoat.Status.IN_WATER -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityType<?> boatType) {
        if (boatType == EntityType.SPRUCE_BOAT || boatType == EntityType.SPRUCE_CHEST_BOAT) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == EntityType.BIRCH_BOAT || boatType == EntityType.BIRCH_CHEST_BOAT) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == EntityType.JUNGLE_BOAT || boatType == EntityType.JUNGLE_CHEST_BOAT) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == EntityType.ACACIA_BOAT || boatType == EntityType.ACACIA_CHEST_BOAT) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == EntityType.DARK_OAK_BOAT || boatType == EntityType.DARK_OAK_CHEST_BOAT) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

