/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreeperPowerEvent;

public class CraftCreeper
extends CraftMonster
implements Creeper {
    public CraftCreeper(CraftServer server, net.minecraft.world.entity.monster.Creeper entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.monster.Creeper getHandle() {
        return (net.minecraft.world.entity.monster.Creeper)this.entity;
    }

    public boolean isPowered() {
        return this.getHandle().isPowered();
    }

    public void setPowered(boolean powered) {
        CreeperPowerEvent.PowerCause cause;
        CreeperPowerEvent.PowerCause powerCause = cause = powered ? CreeperPowerEvent.PowerCause.SET_ON : CreeperPowerEvent.PowerCause.SET_OFF;
        if (this.getHandle().generation || !this.callPowerEvent(cause)) {
            this.getHandle().setPowered(powered);
        }
    }

    private boolean callPowerEvent(CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)this.getHandle().getBukkitEntity(), cause);
        this.server.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }

    public void setMaxFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        this.getHandle().maxSwell = ticks;
    }

    public int getMaxFuseTicks() {
        return this.getHandle().maxSwell;
    }

    public void setFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        Preconditions.checkArgument((ticks <= this.getMaxFuseTicks() ? 1 : 0) != 0, (Object)"ticks > maxFuseTicks");
        this.getHandle().swell = ticks;
    }

    public int getFuseTicks() {
        return this.getHandle().swell;
    }

    public void setExplosionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"radius < 0");
        this.getHandle().explosionRadius = radius;
    }

    public int getExplosionRadius() {
        return this.getHandle().explosionRadius;
    }

    public void explode() {
        this.getHandle().explodeCreeper();
    }

    public void ignite(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        this.getHandle().entityIgniter = ((CraftEntity)entity).getHandle();
        this.getHandle().ignite();
    }

    public void ignite() {
        this.getHandle().ignite();
    }

    public Entity getIgniter() {
        return this.getHandle().entityIgniter != null ? this.getHandle().entityIgniter.getBukkitEntity() : null;
    }

    public void setIgnited(boolean ignited) {
        this.getHandle().setIgnited(ignited);
    }

    public boolean isIgnited() {
        return this.getHandle().isIgnited();
    }
}

