/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import org.bukkit.Color;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class CraftDisplay
extends CraftEntity
implements Display {
    public CraftDisplay(CraftServer server, net.minecraft.world.entity.Display entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.Display getHandle() {
        return (net.minecraft.world.entity.Display)this.entity;
    }

    public Transformation getTransformation() {
        com.mojang.math.Transformation nms = net.minecraft.world.entity.Display.createTransformation(this.getHandle().getEntityData());
        return new Transformation(nms.getTranslation(), nms.getLeftRotation(), nms.getScale(), nms.getRightRotation());
    }

    public void setTransformation(Transformation transformation) {
        Preconditions.checkArgument((transformation != null ? 1 : 0) != 0, (Object)"Transformation cannot be null");
        this.getHandle().setTransformation(new com.mojang.math.Transformation(transformation.getTranslation(), transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation()));
    }

    public void setTransformationMatrix(Matrix4f transformationMatrix) {
        Preconditions.checkArgument((transformationMatrix != null ? 1 : 0) != 0, (Object)"Transformation matrix cannot be null");
        this.getHandle().setTransformation(new com.mojang.math.Transformation((Matrix4fc)transformationMatrix));
    }

    public int getInterpolationDuration() {
        return this.getHandle().getTransformationInterpolationDuration();
    }

    public void setInterpolationDuration(int duration) {
        this.getHandle().setTransformationInterpolationDuration(duration);
    }

    public int getTeleportDuration() {
        return this.getHandle().getEntityData().get(net.minecraft.world.entity.Display.DATA_POS_ROT_INTERPOLATION_DURATION_ID);
    }

    public void setTeleportDuration(int duration) {
        Preconditions.checkArgument((duration >= 0 && duration <= 59 ? 1 : 0) != 0, (String)"duration (%s) cannot be lower than 0 or higher than 59", (int)duration);
        this.getHandle().getEntityData().set(net.minecraft.world.entity.Display.DATA_POS_ROT_INTERPOLATION_DURATION_ID, duration);
    }

    public float getViewRange() {
        return this.getHandle().getViewRange();
    }

    public void setViewRange(float range) {
        this.getHandle().setViewRange(range);
    }

    public float getShadowRadius() {
        return this.getHandle().getShadowRadius();
    }

    public void setShadowRadius(float radius) {
        this.getHandle().setShadowRadius(radius);
    }

    public float getShadowStrength() {
        return this.getHandle().getShadowStrength();
    }

    public void setShadowStrength(float strength) {
        this.getHandle().setShadowStrength(strength);
    }

    public float getDisplayWidth() {
        return this.getHandle().getWidth();
    }

    public void setDisplayWidth(float width) {
        this.getHandle().setWidth(width);
    }

    public float getDisplayHeight() {
        return this.getHandle().getHeight();
    }

    public void setDisplayHeight(float height) {
        this.getHandle().setHeight(height);
    }

    public int getInterpolationDelay() {
        return this.getHandle().getTransformationInterpolationDelay();
    }

    public void setInterpolationDelay(int ticks) {
        this.getHandle().setTransformationInterpolationDelay(ticks);
    }

    public Display.Billboard getBillboard() {
        return Display.Billboard.valueOf((String)this.getHandle().getBillboardConstraints().name());
    }

    public void setBillboard(Display.Billboard billboard) {
        Preconditions.checkArgument((billboard != null ? 1 : 0) != 0, (Object)"Billboard cannot be null");
        this.getHandle().setBillboardConstraints(Display.BillboardConstraints.valueOf(billboard.name()));
    }

    public Color getGlowColorOverride() {
        int color = this.getHandle().getGlowColorOverride();
        return color == -1 ? null : Color.fromARGB((int)color);
    }

    public void setGlowColorOverride(Color color) {
        if (color == null) {
            this.getHandle().setGlowColorOverride(-1);
        } else {
            this.getHandle().setGlowColorOverride(color.asARGB());
        }
    }

    public Display.Brightness getBrightness() {
        Brightness nms = this.getHandle().getBrightnessOverride();
        return nms != null ? new Display.Brightness(nms.block(), nms.sky()) : null;
    }

    public void setBrightness(Display.Brightness brightness) {
        if (brightness != null) {
            this.getHandle().setBrightnessOverride(new Brightness(brightness.getBlockLight(), brightness.getSkyLight()));
        } else {
            this.getHandle().setBrightnessOverride(null);
        }
    }
}

