/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.entity.CraftEnemy;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderDragon;

public class CraftEnderDragon
extends CraftMob
implements org.bukkit.entity.EnderDragon,
CraftEnemy {
    public CraftEnderDragon(CraftServer server, EnderDragon entity) {
        super(server, entity);
    }

    @Override
    public EnderDragon getHandle() {
        return (EnderDragon)this.entity;
    }

    public Set<ComplexEntityPart> getParts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EnderDragonPart part : this.getHandle().getSubEntities()) {
            builder.add((Object)((ComplexEntityPart)part.getBukkitEntity()));
        }
        return builder.build();
    }

    public EnderDragon.Phase getPhase() {
        return EnderDragon.Phase.values()[this.getHandle().getEntityData().get(EnderDragon.DATA_PHASE)];
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.getHandle().getPhaseManager().setPhase(CraftEnderDragon.getMinecraftPhase(phase));
    }

    public static EnderDragon.Phase getBukkitPhase(EnderDragonPhase phase) {
        return EnderDragon.Phase.values()[phase.getId()];
    }

    public static EnderDragonPhase getMinecraftPhase(EnderDragon.Phase phase) {
        return EnderDragonPhase.getById(phase.ordinal());
    }

    public BossBar getBossBar() {
        DragonBattle battle = this.getDragonBattle();
        return battle != null ? battle.getBossBar() : null;
    }

    public DragonBattle getDragonBattle() {
        return this.getHandle().getDragonFight() != null ? new CraftDragonBattle(this.getHandle().getDragonFight()) : null;
    }

    public int getDeathAnimationTicks() {
        return this.getHandle().dragonDeathTime;
    }

    public Location getPodium() {
        return CraftLocation.toBukkit(this.getHandle().getPodium(), this.getWorld());
    }

    public void setPodium(Location location) {
        if (location == null) {
            this.getHandle().setPodium(null);
        } else {
            Preconditions.checkArgument((location.getWorld() == null || location.getWorld().equals((Object)this.getWorld()) ? 1 : 0) != 0, (Object)"You cannot set a podium in a different world to where the dragon is");
            this.getHandle().setPodium(CraftLocation.toBlockPosition(location));
        }
    }
}

