/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.ThrownTrident;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAbstractArrow;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;

public class CraftTrident
extends CraftAbstractArrow
implements Trident {
    public CraftTrident(CraftServer server, ThrownTrident entity) {
        super(server, entity);
    }

    @Override
    public ThrownTrident getHandle() {
        return (ThrownTrident)this.entity;
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().pickupItemStack);
    }

    @Override
    public void setItem(ItemStack itemStack) {
        this.getHandle().pickupItemStack = CraftItemStack.asNMSCopy(itemStack);
    }

    public boolean hasGlint() {
        return this.getHandle().isFoil();
    }

    public void setGlint(boolean glint) {
        this.getHandle().setFoil(glint);
    }

    public int getLoyaltyLevel() {
        return this.getHandle().getLoyalty();
    }

    public void setLoyaltyLevel(int loyaltyLevel) {
        Preconditions.checkArgument((loyaltyLevel >= 0 && loyaltyLevel <= 127 ? 1 : 0) != 0, (Object)"The loyalty level has to be between 0 and 127");
        this.getHandle().setLoyalty((byte)loyaltyLevel);
    }

    public boolean hasDealtDamage() {
        return this.getHandle().dealtDamage;
    }

    public void setHasDealtDamage(boolean hasDealtDamage) {
        this.getHandle().dealtDamage = hasDealtDamage;
    }
}

