/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.monster.Vex;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Mob;

public class CraftVex
extends CraftMonster
implements org.bukkit.entity.Vex {
    public CraftVex(CraftServer server, Vex entity) {
        super(server, entity);
    }

    @Override
    public Vex getHandle() {
        return (Vex)this.entity;
    }

    public Mob getSummoner() {
        net.minecraft.world.entity.Mob owner = this.getHandle().getOwner();
        return owner != null ? (Mob)owner.getBukkitEntity() : null;
    }

    public void setSummoner(Mob summoner) {
        this.getHandle().setOwner(summoner == null ? null : ((CraftMob)summoner).getHandle());
    }

    public boolean hasLimitedLifetime() {
        return this.getHandle().hasLimitedLife;
    }

    public void setLimitedLifetime(boolean hasLimitedLifetime) {
        this.getHandle().hasLimitedLife = hasLimitedLifetime;
    }

    public int getLimitedLifetimeTicks() {
        return this.getHandle().limitedLifeTicks;
    }

    public void setLimitedLifetimeTicks(int ticks) {
        this.getHandle().limitedLifeTicks = ticks;
    }

    public boolean isCharging() {
        return this.getHandle().isCharging();
    }

    public void setCharging(boolean charging) {
        this.getHandle().setIsCharging(charging);
    }

    public Location getBound() {
        BlockPos pos = this.getHandle().getBoundOrigin();
        return pos == null ? null : CraftLocation.toBukkit(pos, this.getWorld());
    }

    public void setBound(Location location) {
        if (location == null) {
            this.getHandle().setBoundOrigin(null);
        } else {
            Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"The bound world cannot be different to the entity's world.");
            this.getHandle().setBoundOrigin(CraftLocation.toBlockPosition(location));
        }
    }

    public int getLifeTicks() {
        return this.getHandle().limitedLifeTicks;
    }

    public void setLifeTicks(int lifeTicks) {
        this.getHandle().setLimitedLife(lifeTicks);
        if (lifeTicks < 0) {
            this.getHandle().hasLimitedLife = false;
        }
    }

    public boolean hasLimitedLife() {
        return this.getHandle().hasLimitedLife;
    }
}

