/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.Wolf;

public class CraftWolf
extends CraftTameableAnimal
implements Wolf {
    public CraftWolf(CraftServer server, net.minecraft.world.entity.animal.wolf.Wolf wolf) {
        super(server, wolf);
    }

    @Override
    public net.minecraft.world.entity.animal.wolf.Wolf getHandle() {
        return (net.minecraft.world.entity.animal.wolf.Wolf)this.entity;
    }

    public boolean isAngry() {
        return this.getHandle().isAngry();
    }

    public void setAngry(boolean angry) {
        if (angry) {
            this.getHandle().startPersistentAngerTimer();
        } else {
            this.getHandle().stopBeingAngry();
        }
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().getCollarColor().getId()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().setCollarColor(net.minecraft.world.item.DyeColor.byId(color.getWoolData()));
    }

    public boolean isWet() {
        return this.getHandle().isWet;
    }

    public float getTailAngle() {
        return this.getHandle().getTailAngle();
    }

    public boolean isInterested() {
        return this.getHandle().isInterested();
    }

    public void setInterested(boolean interested) {
        this.getHandle().setIsInterested(interested);
    }

    public Wolf.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().getVariant());
    }

    public void setVariant(Wolf.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().setVariant(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public Wolf.SoundVariant getSoundVariant() {
        return CraftSoundVariant.minecraftHolderToBukkit(this.getHandle().getSoundVariant());
    }

    public void setSoundVariant(Wolf.SoundVariant soundVariant) {
        Preconditions.checkArgument((soundVariant != null ? 1 : 0) != 0, (Object)"soundVariant cannot be null");
        this.getHandle().setSoundVariant(CraftSoundVariant.bukkitToMinecraftHolder(soundVariant));
    }

    public static class CraftVariant
    implements Wolf.Variant,
    Handleable<WolfVariant> {
        private final NamespacedKey key;
        private final WolfVariant variant;

        public static Wolf.Variant minecraftToBukkit(WolfVariant minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.WOLF_VARIANT);
        }

        public static Wolf.Variant minecraftHolderToBukkit(Holder<WolfVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.value());
        }

        public static WolfVariant bukkitToMinecraft(Wolf.Variant bukkit) {
            return (WolfVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfVariant> bukkitToMinecraftHolder(Wolf.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            Registry<WolfVariant> registry = CraftRegistry.getMinecraftRegistry(Registries.WOLF_VARIANT);
            Holder<WolfVariant> holder = registry.wrapAsHolder(CraftVariant.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.Reference) {
                Holder.Reference holder2 = (Holder.Reference)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own wolf variant with out properly registering it.");
        }

        public CraftVariant(NamespacedKey key, WolfVariant variant) {
            this.key = key;
            this.variant = variant;
        }

        @Override
        public WolfVariant getHandle() {
            return this.variant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftVariant)) {
                return false;
            }
            CraftVariant otherVariant = (CraftVariant)other;
            return this.getKey().equals((Object)otherVariant.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }

    public static class CraftSoundVariant
    implements Wolf.SoundVariant,
    Handleable<WolfSoundVariant> {
        private final NamespacedKey key;
        private final WolfSoundVariant soundVariant;

        public static Wolf.SoundVariant minecraftToBukkit(WolfSoundVariant minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftToBukkit(minecraft, Registries.WOLF_SOUND_VARIANT);
        }

        public static Wolf.SoundVariant minecraftHolderToBukkit(Holder<WolfSoundVariant> minecraft) {
            return CraftSoundVariant.minecraftToBukkit(minecraft.value());
        }

        public static WolfSoundVariant bukkitToMinecraft(Wolf.SoundVariant bukkit) {
            return (WolfSoundVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfSoundVariant> bukkitToMinecraftHolder(Wolf.SoundVariant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            Registry<WolfSoundVariant> registry = CraftRegistry.getMinecraftRegistry(Registries.WOLF_SOUND_VARIANT);
            Holder<WolfSoundVariant> holder = registry.wrapAsHolder(CraftSoundVariant.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.Reference) {
                Holder.Reference holder2 = (Holder.Reference)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own wolf sound variant with out properly registering it.");
        }

        public CraftSoundVariant(NamespacedKey key, WolfSoundVariant soundVariant) {
            this.key = key;
            this.soundVariant = soundVariant;
        }

        @Override
        public WolfSoundVariant getHandle() {
            return this.soundVariant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftSoundVariant)) {
                return false;
            }
            CraftSoundVariant otherVariant = (CraftSoundVariant)other;
            return this.getKey().equals((Object)otherVariant.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }
}

