/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import io.papermc.paper.inventory.PaperInventoryCustomHolderContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class CraftInventoryCustom
extends CraftInventory {
    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, Container delegate) {
        super(new PaperInventoryCustomHolderContainer(owner, delegate, type));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type) {
        super(new MinecraftInventory(owner, type));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, Component title) {
        super(new MinecraftInventory(owner, type, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, String title) {
        super(new MinecraftInventory(owner, type, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size) {
        super(new MinecraftInventory(owner, size));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size, Component title) {
        super(new MinecraftInventory(owner, size, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size, String title) {
        super(new MinecraftInventory(owner, size, title));
    }

    public String getTitle() {
        Container container = this.inventory;
        if (container instanceof MinecraftInventory) {
            MinecraftInventory minecraftInventory = (MinecraftInventory)container;
            return minecraftInventory.getTitle();
        }
        container = this.inventory;
        if (container instanceof PaperInventoryCustomHolderContainer) {
            PaperInventoryCustomHolderContainer customHolderContainer = (PaperInventoryCustomHolderContainer)container;
            return customHolderContainer.getTitle();
        }
        throw new UnsupportedOperationException(String.valueOf(this.inventory.getClass()) + " isn't a recognized Container type here");
    }

    public Component title() {
        Container container = this.inventory;
        if (container instanceof MinecraftInventory) {
            MinecraftInventory minecraftInventory = (MinecraftInventory)container;
            return minecraftInventory.title();
        }
        container = this.inventory;
        if (container instanceof PaperInventoryCustomHolderContainer) {
            PaperInventoryCustomHolderContainer customHolderContainer = (PaperInventoryCustomHolderContainer)container;
            return customHolderContainer.title();
        }
        throw new UnsupportedOperationException(String.valueOf(this.inventory.getClass()) + " isn't a recognized Container type here");
    }

    static class MinecraftInventory
    implements Container {
        private final NonNullList<ItemStack> items;
        private int maxStack = 99;
        private final List<HumanEntity> viewers;
        private final String title;
        private final Component adventure$title;
        private InventoryType type;
        private final InventoryHolder owner;

        public MinecraftInventory(InventoryHolder owner, InventoryType type, Component title) {
            this(owner, type.getDefaultSize(), title);
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, InventoryType type) {
            this(owner, type.getDefaultSize(), type.getDefaultTitle());
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, InventoryType type, String title) {
            this(owner, type.getDefaultSize(), title);
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, int size) {
            this(owner, size, "Chest");
        }

        public MinecraftInventory(InventoryHolder owner, int size, String title) {
            Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"title cannot be null");
            this.items = NonNullList.withSize(size, ItemStack.EMPTY);
            this.title = title;
            this.adventure$title = LegacyComponentSerializer.legacySection().deserialize(title);
            this.viewers = new ArrayList<HumanEntity>();
            this.owner = owner;
            this.type = InventoryType.CHEST;
        }

        public MinecraftInventory(InventoryHolder owner, int size, Component title) {
            Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"Title cannot be null");
            this.items = NonNullList.withSize(size, ItemStack.EMPTY);
            this.title = LegacyComponentSerializer.legacySection().serialize(title);
            this.adventure$title = title;
            this.viewers = new ArrayList<HumanEntity>();
            this.owner = owner;
            this.type = InventoryType.CHEST;
        }

        @Override
        public int getContainerSize() {
            return this.items.size();
        }

        @Override
        public ItemStack getItem(int slot) {
            return this.items.get(slot);
        }

        @Override
        public ItemStack removeItem(int slot, int amount) {
            ItemStack result;
            ItemStack stack = this.getItem(slot);
            if (stack == ItemStack.EMPTY) {
                return stack;
            }
            if (stack.getCount() <= amount) {
                this.setItem(slot, ItemStack.EMPTY);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, amount);
                stack.shrink(amount);
            }
            this.setChanged();
            return result;
        }

        @Override
        public ItemStack removeItemNoUpdate(int slot) {
            ItemStack result;
            ItemStack stack = this.getItem(slot);
            if (stack == ItemStack.EMPTY) {
                return stack;
            }
            if (stack.getCount() <= 1) {
                this.setItem(slot, null);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, 1);
                stack.shrink(1);
            }
            return result;
        }

        @Override
        public void setItem(int slot, ItemStack stack) {
            this.items.set(slot, stack);
            if (stack != ItemStack.EMPTY && this.getMaxStackSize() > 0 && stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
        }

        @Override
        public int getMaxStackSize() {
            return this.maxStack;
        }

        @Override
        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        @Override
        public void setChanged() {
        }

        @Override
        public boolean stillValid(Player player) {
            return true;
        }

        @Override
        public List<ItemStack> getContents() {
            return this.items;
        }

        @Override
        public void onOpen(CraftHumanEntity player) {
            this.viewers.add(player);
        }

        @Override
        public void onClose(CraftHumanEntity player) {
            this.viewers.remove(player);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.viewers;
        }

        public InventoryType getType() {
            return this.type;
        }

        @Override
        public InventoryHolder getOwner() {
            return this.owner;
        }

        @Override
        public boolean canPlaceItem(int slot, ItemStack stack) {
            return true;
        }

        @Override
        public void startOpen(Player player) {
        }

        @Override
        public void stopOpen(Player player) {
        }

        @Override
        public void clearContent() {
            this.items.clear();
        }

        @Override
        public Location getLocation() {
            return null;
        }

        public Component title() {
            return this.adventure$title;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public boolean isEmpty() {
            ItemStack itemstack;
            Iterator iterator = this.items.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
            return false;
        }
    }
}

