/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.trim;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.HolderableBase;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.Holderable;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jetbrains.annotations.NotNull;

public class CraftTrimMaterial
extends HolderableBase<TrimMaterial>
implements org.bukkit.inventory.meta.trim.TrimMaterial {
    public static org.bukkit.inventory.meta.trim.TrimMaterial minecraftToBukkit(TrimMaterial minecraft) {
        return (org.bukkit.inventory.meta.trim.TrimMaterial)CraftRegistry.minecraftToBukkit(minecraft, Registries.TRIM_MATERIAL);
    }

    public static org.bukkit.inventory.meta.trim.TrimMaterial minecraftHolderToBukkit(Holder<TrimMaterial> minecraft) {
        return (org.bukkit.inventory.meta.trim.TrimMaterial)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.TRIM_MATERIAL);
    }

    public static TrimMaterial bukkitToMinecraft(org.bukkit.inventory.meta.trim.TrimMaterial bukkit) {
        return (TrimMaterial)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<TrimMaterial> bukkitToMinecraftHolder(org.bukkit.inventory.meta.trim.TrimMaterial bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.TRIM_MATERIAL);
    }

    public static Object bukkitToObject(org.bukkit.inventory.meta.trim.TrimMaterial bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((CraftTrimMaterial)bukkit).toBukkitSerializationObject(TrimMaterial.DIRECT_CODEC);
    }

    public static org.bukkit.inventory.meta.trim.TrimMaterial objectToBukkit(Object object) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0);
        return (org.bukkit.inventory.meta.trim.TrimMaterial)Holderable.fromBukkitSerializationObject(object, TrimMaterial.CODEC, RegistryKey.TRIM_MATERIAL);
    }

    public CraftTrimMaterial(Holder<TrimMaterial> holder) {
        super(holder);
    }

    @NotNull
    public String getTranslationKey() {
        if (!(((TrimMaterial)this.getHandle()).description().getContents() instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        return ((TranslatableContents)((TrimMaterial)this.getHandle()).description().getContents()).getKey();
    }

    public Component description() {
        return PaperAdventure.asAdventure(((TrimMaterial)this.getHandle()).description());
    }
}

