/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view.builder;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;
import org.jspecify.annotations.Nullable;

public abstract class CraftAbstractInventoryViewBuilder<V extends InventoryView>
implements InventoryViewBuilder<V> {
    protected final MenuType<?> handle;
    protected boolean checkReachable = false;
    protected @Nullable net.kyori.adventure.text.Component title = null;
    protected Component defaultTitle = null;

    public CraftAbstractInventoryViewBuilder(MenuType<?> handle) {
        this.handle = handle;
    }

    public InventoryViewBuilder<V> title(@Nullable net.kyori.adventure.text.Component title) {
        this.title = title;
        return this;
    }

    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof ServerPlayer), (Object)"The given player must be an ServerPlayer");
        ServerPlayer serverPlayer = (ServerPlayer)craftHuman.getHandle();
        AbstractContainerMenu container = this.buildContainer(serverPlayer);
        container.checkReachable = this.checkReachable;
        container.setTitle(this.title != null ? PaperAdventure.asVanilla(this.title) : this.defaultTitle);
        return (V)container.getBukkitView();
    }

    protected abstract AbstractContainerMenu buildContainer(ServerPlayer var1);
}

