/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view.builder;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.Merchant;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftMerchant;
import org.bukkit.craftbukkit.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.MerchantInventoryViewBuilder;
import org.jspecify.annotations.Nullable;

public class CraftMerchantInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements MerchantInventoryViewBuilder<V> {
    private @Nullable Merchant merchant;

    public CraftMerchantInventoryViewBuilder(MenuType<?> handle) {
        super(handle);
    }

    @Override
    public MerchantInventoryViewBuilder<V> title(@Nullable Component title) {
        return (MerchantInventoryViewBuilder)super.title(title);
    }

    public MerchantInventoryViewBuilder<V> merchant(org.bukkit.inventory.Merchant merchant) {
        this.merchant = ((CraftMerchant)merchant).getMerchant();
        return this;
    }

    public MerchantInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    @Override
    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof ServerPlayer), (Object)"The given player must be an ServerPlayer");
        ServerPlayer serverPlayer = (ServerPlayer)craftHuman.getHandle();
        if (this.merchant == null) {
            this.merchant = this.title == null ? new CraftMerchantCustom().getMerchant() : new CraftMerchantCustom(this.title).getMerchant();
        }
        MerchantMenu container = new MerchantMenu(serverPlayer.nextContainerCounter(), serverPlayer.getInventory(), this.merchant);
        container.checkReachable = this.checkReachable;
        this.setDefaultTitle(this.merchant);
        container.setTitle(this.title != null ? PaperAdventure.asVanilla(this.title) : this.defaultTitle);
        return (V)container.getBukkitView();
    }

    private void setDefaultTitle(Merchant merchant) {
        if (merchant instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)merchant;
            this.defaultTitle = villager.getDisplayName();
        } else if (merchant instanceof CraftMerchantCustom.MinecraftMerchant) {
            CraftMerchantCustom.MinecraftMerchant custom = (CraftMerchantCustom.MinecraftMerchant)merchant;
            this.defaultTitle = custom.getScoreboardDisplayName();
        } else {
            throw new IllegalStateException("Provided merchant during MenuType creation can not find a default title! This is a bug!");
        }
    }

    @Override
    protected AbstractContainerMenu buildContainer(ServerPlayer player) {
        throw new UnsupportedOperationException("buildContainer is not supported for CraftMerchantInventoryViewBuilder");
    }

    public MerchantInventoryViewBuilder<V> copy() {
        CraftMerchantInventoryViewBuilder<V> copy = new CraftMerchantInventoryViewBuilder<V>(this.handle);
        copy.checkReachable = this.checkReachable;
        copy.merchant = this.merchant;
        copy.title = this.title;
        return copy;
    }
}

