/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.RenderType;

public final class CraftCriteria
implements Criteria {
    private static final Map<String, CraftCriteria> DEFAULTS;
    private static final CraftCriteria DUMMY;
    final ObjectiveCriteria criteria;
    final String name;

    private CraftCriteria(String name) {
        this.name = name;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(ObjectiveCriteria criteria) {
        this.criteria = criteria;
        this.name = criteria.getName();
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.criteria.isReadOnly();
    }

    public RenderType getDefaultRenderType() {
        return RenderType.values()[this.criteria.getDefaultRenderType().ordinal()];
    }

    public static CraftCriteria getFromNMS(ObjectiveCriteria criteria) {
        return Objects.requireNonNullElseGet(DEFAULTS.get(criteria.getName()), () -> new CraftCriteria(criteria));
    }

    public static CraftCriteria getFromNMS(Objective objective) {
        return CraftCriteria.getFromNMS(objective.getCriteria());
    }

    public static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        return ObjectiveCriteria.byName(name).map(CraftCriteria::new).orElseGet(() -> new CraftCriteria(name));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftCriteria)) {
            return false;
        }
        CraftCriteria craftCriteria = (CraftCriteria)obj;
        return craftCriteria.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode() ^ CraftCriteria.class.hashCode();
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (Map.Entry<String, ObjectiveCriteria> entry : ObjectiveCriteria.CRITERIA_CACHE.entrySet()) {
            String name = entry.getKey();
            ObjectiveCriteria criteria = entry.getValue();
            defaults.put((Object)name, (Object)new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get(ObjectiveCriteria.DUMMY.getName());
    }
}

