/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.ChatFormatting;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final PlayerTeam team;

    CraftTeam(CraftScoreboard scoreboard, PlayerTeam team) {
        super(scoreboard);
        this.team = team;
    }

    public String getName() {
        this.checkState();
        return this.team.getName();
    }

    public Component displayName() throws IllegalStateException {
        this.checkState();
        return PaperAdventure.asAdventure(this.team.getDisplayName());
    }

    public void displayName(Component displayName) throws IllegalStateException, IllegalArgumentException {
        if (displayName == null) {
            displayName = Component.empty();
        }
        this.checkState();
        this.team.setDisplayName(PaperAdventure.asVanilla(displayName));
    }

    public Component prefix() throws IllegalStateException {
        this.checkState();
        return PaperAdventure.asAdventure(this.team.getPlayerPrefix());
    }

    public void prefix(Component prefix) throws IllegalStateException, IllegalArgumentException {
        if (prefix == null) {
            prefix = Component.empty();
        }
        this.checkState();
        this.team.setPlayerPrefix(PaperAdventure.asVanilla(prefix));
    }

    public Component suffix() throws IllegalStateException {
        this.checkState();
        return PaperAdventure.asAdventure(this.team.getPlayerSuffix());
    }

    public void suffix(Component suffix) throws IllegalStateException, IllegalArgumentException {
        if (suffix == null) {
            suffix = Component.empty();
        }
        this.checkState();
        this.team.setPlayerSuffix(PaperAdventure.asVanilla(suffix));
    }

    public boolean hasColor() {
        this.checkState();
        return this.team.getColor().getColor() != null;
    }

    public TextColor color() throws IllegalStateException {
        Preconditions.checkState((this.team.getColor().getColor() != null ? 1 : 0) != 0, (Object)"Team colors must have hex values");
        this.checkState();
        TextColor color = TextColor.color((int)this.team.getColor().getColor());
        if (!(color instanceof NamedTextColor)) {
            throw new IllegalStateException("Team doesn't have a NamedTextColor");
        }
        return color;
    }

    public void color(NamedTextColor color) {
        this.checkState();
        this.team.setColor(color == null ? ChatFormatting.RESET : PaperAdventure.asVanilla((TextColor)color));
    }

    public String getDisplayName() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.getDisplayName());
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        this.checkState();
        this.team.setDisplayName(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getPrefix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.getPlayerPrefix());
    }

    public void setPrefix(String prefix) {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix cannot be null");
        this.checkState();
        this.team.setPlayerPrefix(CraftChatMessage.fromStringOrNull(prefix));
    }

    public String getSuffix() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.getPlayerSuffix());
    }

    public void setSuffix(String suffix) {
        Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"Suffix cannot be null");
        this.checkState();
        this.team.setPlayerSuffix(CraftChatMessage.fromStringOrNull(suffix));
    }

    public ChatColor getColor() {
        this.checkState();
        return CraftChatMessage.getColor(this.team.getColor());
    }

    public void setColor(ChatColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"Color cannot be null");
        this.checkState();
        this.team.setColor(CraftChatMessage.getColor(color));
    }

    public boolean allowFriendlyFire() {
        this.checkState();
        return this.team.isAllowFriendlyFire();
    }

    public void setAllowFriendlyFire(boolean enabled) {
        this.checkState();
        this.team.setAllowFriendlyFire(enabled);
    }

    public boolean canSeeFriendlyInvisibles() {
        this.checkState();
        return this.team.canSeeFriendlyInvisibles();
    }

    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.checkState();
        this.team.setSeeFriendlyInvisibles(enabled);
    }

    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        this.checkState();
        return CraftTeam.notchToBukkit(this.team.getNameTagVisibility());
    }

    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        this.checkState();
        this.team.setNameTagVisibility(CraftTeam.bukkitToNotch(visibility));
    }

    public Set<OfflinePlayer> getPlayers() {
        this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.getPlayers()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName));
        }
        return players.build();
    }

    public Set<String> getEntries() {
        this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.getPlayers()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    public int getSize() {
        this.checkState();
        return this.team.getPlayers().size();
    }

    public void addPlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    public void addEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        this.getScoreboard().getHandle().addPlayerToTeam(entry, this.team);
    }

    public void addEntities(Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        this.addEntries(entities.stream().map(entity -> ((CraftEntity)entity).getHandle().getScoreboardName()).toList());
    }

    public void addEntries(Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        this.checkState();
        ((ServerScoreboard)this.getScoreboard().getHandle()).addPlayersToTeam(entries, this.team);
    }

    public boolean removePlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    public boolean removeEntry(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        if (!this.team.getPlayers().contains(entry)) {
            return false;
        }
        this.getScoreboard().getHandle().removePlayerFromTeam(entry, this.team);
        return true;
    }

    public boolean removeEntities(Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        return this.removeEntries(entities.stream().map(entity -> ((CraftEntity)entity).getHandle().getScoreboardName()).toList());
    }

    public boolean removeEntries(Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        for (String entry : entries) {
            if (!this.team.getPlayers().contains(entry)) continue;
            ((ServerScoreboard)this.getScoreboard().getHandle()).removePlayersFromTeam(entries, this.team);
            return true;
        }
        return false;
    }

    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        return this.team.getPlayers().contains(entry);
    }

    @Override
    public void unregister() {
        this.checkState();
        this.getScoreboard().getHandle().removePlayerTeam(this.team);
    }

    public Team.OptionStatus getOption(Team.Option option) {
        this.checkState();
        Enum value = switch (option) {
            default -> throw new MatchException(null, null);
            case Team.Option.NAME_TAG_VISIBILITY -> this.team.getNameTagVisibility();
            case Team.Option.DEATH_MESSAGE_VISIBILITY -> this.team.getDeathMessageVisibility();
            case Team.Option.COLLISION_RULE -> this.team.getCollisionRule();
        };
        return Team.OptionStatus.values()[value.ordinal()];
    }

    public void setOption(Team.Option option, Team.OptionStatus status) {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.setNameTagVisibility(Team.Visibility.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.setDeathMessageVisibility(Team.Visibility.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.setCollisionRule(Team.CollisionRule.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + String.valueOf(option));
            }
        }
    }

    public void addEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.addEntry(((CraftEntity)entity).getHandle().getScoreboardName());
    }

    public boolean removeEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.removeEntry(((CraftEntity)entity).getHandle().getScoreboardName());
    }

    public boolean hasEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.hasEntry(((CraftEntity)entity).getHandle().getScoreboardName());
    }

    public Iterable<? extends Audience> audiences() {
        this.checkState();
        ArrayList<Player> audiences = new ArrayList<Player>();
        for (String playerName : this.team.getPlayers()) {
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) continue;
            audiences.add(player);
        }
        return audiences;
    }

    @Deprecated
    public static Team.Visibility bukkitToNotch(NameTagVisibility visibility) {
        return switch (visibility) {
            default -> throw new MatchException(null, null);
            case NameTagVisibility.ALWAYS -> Team.Visibility.ALWAYS;
            case NameTagVisibility.NEVER -> Team.Visibility.NEVER;
            case NameTagVisibility.HIDE_FOR_OTHER_TEAMS -> Team.Visibility.HIDE_FOR_OTHER_TEAMS;
            case NameTagVisibility.HIDE_FOR_OWN_TEAM -> Team.Visibility.HIDE_FOR_OWN_TEAM;
        };
    }

    @Deprecated
    public static NameTagVisibility notchToBukkit(Team.Visibility visibility) {
        return switch (visibility) {
            default -> throw new MatchException(null, null);
            case Team.Visibility.ALWAYS -> NameTagVisibility.ALWAYS;
            case Team.Visibility.NEVER -> NameTagVisibility.NEVER;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> NameTagVisibility.HIDE_FOR_OWN_TEAM;
        };
    }

    @Override
    void checkState() {
        Preconditions.checkState((this.getScoreboard().getHandle().getPlayerTeam(this.team.getName()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return Objects.equals(this.team, other.team);
    }
}

