/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.tag;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.bukkit.GameEvent;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.tag.CraftTag;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.jetbrains.annotations.NotNull;

public class CraftGameEventTag
extends CraftTag<net.minecraft.world.level.gameevent.GameEvent, GameEvent> {
    private static final Map<GameEvent, ResourceKey<net.minecraft.world.level.gameevent.GameEvent>> KEY_CACHE = Collections.synchronizedMap(new IdentityHashMap());

    public CraftGameEventTag(Registry<net.minecraft.world.level.gameevent.GameEvent> registry, TagKey<net.minecraft.world.level.gameevent.GameEvent> tag) {
        super(registry, tag);
    }

    public boolean isTagged(@NotNull GameEvent gameEvent) {
        return this.registry.getOrThrow(KEY_CACHE.computeIfAbsent(gameEvent, event -> ResourceKey.create(Registries.GAME_EVENT, CraftNamespacedKey.toMinecraft(event.getKey())))).is(this.tag);
    }

    @NotNull
    public Set<GameEvent> getValues() {
        return this.getHandle().stream().map(nms -> Objects.requireNonNull(GameEvent.getByKey((NamespacedKey)CraftNamespacedKey.fromMinecraft(BuiltInRegistries.GAME_EVENT.getKey((net.minecraft.world.level.gameevent.GameEvent)nms.value()))), () -> String.valueOf(nms) + " is not a recognized game event")).collect(Collectors.toUnmodifiableSet());
    }
}

