/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.adventure.AdventureComponent;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.VersionedComponentSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.util.ExtraCodecs;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.CraftRegistry;

public final class CraftChatMessage {
    private static final Map<Character, ChatFormatting> formatMap;
    private static VersionedComponentSerializer bungeeSerializer;

    public static ChatFormatting getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(ChatFormatting format) {
        return ChatColor.getByChar((char)format.code);
    }

    public static Optional<Component> fromStringOrOptional(String message) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message));
    }

    public static Optional<Component> fromStringOrOptional(String message, boolean keepNewlines) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message, keepNewlines));
    }

    public static Component fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static Component fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static Component fromStringOrEmpty(String message) {
        return CraftChatMessage.fromStringOrEmpty(message, false);
    }

    public static Component fromStringOrEmpty(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static Component[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static Component[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static Component[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(Component component) {
        return Component.Serializer.toJson(component, CraftRegistry.getMinecraftRegistry());
    }

    public static String toJSONOrNull(Component component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static Component fromJSON(String jsonMessage) throws JsonParseException {
        return Component.Serializer.fromJson(jsonMessage, (HolderLookup.Provider)CraftRegistry.getMinecraftRegistry());
    }

    public static Component fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex) {
            return null;
        }
    }

    public static Component fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static Component fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    public static Component fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, nullable, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static Component fromJSONOrString(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        Component component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromString(trimmedContent, keepNewlines)[0];
            }
            return component;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    public static String fromComponent(Component component) {
        if (component == null) {
            return "";
        }
        if (component instanceof AdventureComponent) {
            component = ((AdventureComponent)component).deepConverted();
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (Component c : component) {
            Style modi = c.getStyle();
            TextColor color = modi.getColor();
            if (c.getContents() != PlainTextContents.EMPTY || color != null) {
                if (color != null) {
                    if (color.format != null) {
                        out.append(color.format);
                    } else {
                        out.append('\u00a7').append("x");
                        for (char magic : color.serialize().substring(1).toCharArray()) {
                            out.append('\u00a7').append(magic);
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append(ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.isBold()) {
                out.append(ChatFormatting.BOLD);
                hadFormat = true;
            }
            if (modi.isItalic()) {
                out.append(ChatFormatting.ITALIC);
                hadFormat = true;
            }
            if (modi.isUnderlined()) {
                out.append(ChatFormatting.UNDERLINE);
                hadFormat = true;
            }
            if (modi.isStrikethrough()) {
                out.append(ChatFormatting.STRIKETHROUGH);
                hadFormat = true;
            }
            if (modi.isObfuscated()) {
                out.append(ChatFormatting.OBFUSCATED);
                hadFormat = true;
            }
            c.getContents().visit(x -> {
                out.append(x);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static String bungeeToJson(BaseComponent ... components) {
        return bungeeSerializer.toString(components);
    }

    public static BaseComponent[] jsonToBungee(String json) {
        return bungeeSerializer.parse(json);
    }

    public static Component bungeeToVanilla(BaseComponent ... components) {
        return CraftChatMessage.fromJSON(CraftChatMessage.bungeeToJson(components));
    }

    public static BaseComponent[] vanillaToBungee(Component component) {
        return CraftChatMessage.jsonToBungee(CraftChatMessage.toJSON(component));
    }

    private CraftChatMessage() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ChatFormatting format : ChatFormatting.values()) {
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
        }
        formatMap = builder.build();
        bungeeSerializer = VersionedComponentSerializer.forVersion((ChatVersion)ChatVersion.V1_21_5);
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final Style EMPTY = Style.EMPTY.withItalic(false);
        private static final Style RESET = Style.EMPTY.withBold(false).withItalic(false).withUnderlined(false).withStrikethrough(false).withObfuscated(false);
        private final List<Component> list = new ArrayList<Component>();
        private MutableComponent currentChatComponent = Component.empty();
        private Style modifier = Style.EMPTY;
        private final Component[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new Component[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            hasReset = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ROOT).charAt(1);
                        format = CraftChatMessage.formatMap.get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl30
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl69
lbl30:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl37
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = StringMessage.RESET.withColor((TextColor)TextColor.parseColor(this.hex.toString()).result().orElse(null));
                            this.hex = null;
                        }
                        ** GOTO lbl69
lbl37:
                        // 1 sources

                        if (!format.isFormat() || format == ChatFormatting.RESET) ** GOTO lbl56
                        switch (1.$SwitchMap$net$minecraft$ChatFormatting[format.ordinal()]) {
                            case 1: {
                                this.modifier = this.modifier.withBold(Boolean.TRUE);
                                ** GOTO lbl69
                            }
                            case 2: {
                                this.modifier = this.modifier.withItalic(Boolean.TRUE);
                                ** GOTO lbl69
                            }
                            case 3: {
                                this.modifier = this.modifier.withStrikethrough(Boolean.TRUE);
                                ** GOTO lbl69
                            }
                            case 4: {
                                this.modifier = this.modifier.withUnderlined(Boolean.TRUE);
                                ** GOTO lbl69
                            }
                            case 5: {
                                this.modifier = this.modifier.withObfuscated(Boolean.TRUE);
                                ** GOTO lbl69
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl56:
                        // 1 sources

                        previous = this.modifier;
                        this.modifier = (hasReset == false ? StringMessage.RESET : StringMessage.EMPTY).withColor(format);
                        hasReset = true;
                        if (previous.isBold()) {
                            this.modifier = this.modifier.withBold(false);
                        }
                        if (previous.isItalic()) {
                            this.modifier = this.modifier.withItalic(false);
                        }
                        if (previous.isObfuscated()) {
                            this.modifier = this.modifier.withObfuscated(false);
                        }
                        if (previous.isStrikethrough()) {
                            this.modifier = this.modifier.withStrikethrough(false);
                        }
                        if (previous.isUnderlined()) {
                            this.modifier = this.modifier.withUnderlined(false);
                        }
lbl69:
                        // 10 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + (String)match;
                        }
                        ExtraCodecs.UNTRUSTED_URI.parse((DynamicOps)JavaOps.INSTANCE, match).ifSuccess((Consumer<URI>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$0(java.net.URI ), (Ljava/net/URI;)V)((StringMessage)this));
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.withClickEvent(null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new Component[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            MutableComponent addition = Component.literal(this.message.substring(this.currentIndex, index)).setStyle(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = Component.empty();
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.append(addition);
        }

        private Component[] getOutput() {
            return this.output;
        }

        private /* synthetic */ void lambda$new$0(URI uri) {
            this.modifier = this.modifier.withClickEvent(new ClickEvent.OpenUrl(uri));
        }
    }
}

