/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;

public final class CraftLocation {
    private CraftLocation() {
    }

    public static Location toBukkit(Vec3 vec3) {
        return CraftLocation.toBukkit(vec3, null);
    }

    public static Location toBukkit(Vec3 vec3, World world) {
        return CraftLocation.toBukkit(vec3, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(Vec3 vec3, World world, float yaw, float pitch) {
        return new Location(world, vec3.x(), vec3.y(), vec3.z(), yaw, pitch);
    }

    public static Location toBukkit(BlockPos pos) {
        return CraftLocation.toBukkit(pos, (World)null);
    }

    public static Location toBukkit(BlockPos pos, Level world) {
        return CraftLocation.toBukkit(pos, (World)world.getWorld(), 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPos pos, World world) {
        return CraftLocation.toBukkit(pos, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPos pos, World world, float yaw, float pitch) {
        return new Location(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), yaw, pitch);
    }

    public static Location toBukkit(Node point, Level world) {
        return new Location((World)world.getWorld(), (double)point.x, (double)point.y, (double)point.z);
    }

    public static BlockPos toBlockPosition(Location loc) {
        return new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static GlobalPos toGlobalPos(Location loc) {
        return GlobalPos.of(((CraftWorld)loc.getWorld()).getHandle().dimension(), CraftLocation.toBlockPosition(loc));
    }

    public static Location fromGlobalPos(GlobalPos globalPos) {
        return CraftLocation.toBukkit(globalPos.pos(), (Level)MinecraftServer.getServer().getLevel(globalPos.dimension()));
    }

    public static Vec3 toVec3(Location loc) {
        return new Vec3(loc.getX(), loc.getY(), loc.getZ());
    }
}

