/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.entity;

import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.utility.Util;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingPlaceEvent;

public final class HangingPlaceListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onHangingPlace(HangingPlaceEvent event) {
        Hanging entity = event.getEntity();
        Player player = event.getPlayer();
        if (entity instanceof ItemFrame || entity instanceof Painting) {
            int artId;
            Material material;
            Block blockEvent = event.getEntity().getLocation().getBlock();
            String blockData = null;
            if (entity instanceof ItemFrame) {
                material = BukkitAdapter.ADAPTER.getFrameType((Entity)entity);
                ItemFrame itemFrame = (ItemFrame)entity;
                blockData = "FACING=" + itemFrame.getFacing().name();
                artId = 0;
            } else {
                material = Material.PAINTING;
                Painting painting = (Painting)entity;
                blockData = "FACING=" + painting.getFacing().name();
                artId = Util.getArtId(painting.getArt().toString(), true);
            }
            boolean inspect = false;
            if (ConfigHandler.inspecting.get(player.getName()) != null && ConfigHandler.inspecting.get(player.getName()).booleanValue()) {
                inspect = true;
                event.setCancelled(true);
            }
            if (!event.isCancelled() && Config.getConfig((World)blockEvent.getWorld()).BLOCK_PLACE && !inspect) {
                Queue.queueBlockPlace(player.getName(), blockEvent.getState(), blockEvent.getType(), null, material, artId, 1, blockData);
            }
        }
    }
}

