/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.player;

import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.lookup.ChestTransactionLookup;
import net.coreprotect.language.Phrase;
import net.coreprotect.listener.player.PlayerInteractEntityListener;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.Util;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public final class ArmorStandManipulateListener
extends Queue
implements Listener {
    public static void inspectHangingTransactions(final Location location, final Player finalPlayer) {
        class BasicThread
        implements Runnable {
            BasicThread() {
            }

            @Override
            public void run() {
                Object[] lookupThrottle;
                if (!finalPlayer.hasPermission("coreprotect.inspect")) {
                    Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
                    ConfigHandler.inspecting.put(finalPlayer.getName(), false);
                    return;
                }
                if (ConfigHandler.converterRunning) {
                    Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
                    return;
                }
                if (ConfigHandler.purgeRunning) {
                    Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
                    return;
                }
                if (ConfigHandler.lookupThrottle.get(finalPlayer.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(finalPlayer.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
                    Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                    return;
                }
                ConfigHandler.lookupThrottle.put(finalPlayer.getName(), new Object[]{true, System.currentTimeMillis()});
                try (Connection connection = Database.getConnection(true);){
                    if (connection != null) {
                        Statement statement = connection.createStatement();
                        List<String> blockData = ChestTransactionLookup.performLookup(null, statement, location, (CommandSender)finalPlayer, 1, 7, true);
                        for (String data : blockData) {
                            Chat.sendComponent((CommandSender)finalPlayer, data);
                        }
                        statement.close();
                    } else {
                        Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ConfigHandler.lookupThrottle.put(finalPlayer.getName(), new Object[]{false, System.currentTimeMillis()});
            }
        }
        BasicThread runnable = new BasicThread();
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerArmorStandManipulateEvent(PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        ArmorStand armorStand = event.getRightClicked();
        EntityEquipment equipment = armorStand.getEquipment();
        ItemStack[] oldContents = Util.getArmorStandContents(equipment);
        ItemStack[] newContents = (ItemStack[])oldContents.clone();
        ItemStack item = event.getArmorStandItem();
        ItemStack playerItem = event.getPlayerItem();
        if (ConfigHandler.inspecting.get(player.getName()) != null && ConfigHandler.inspecting.get(player.getName()).booleanValue()) {
            if (BlockGroup.CONTAINERS.contains(Material.ARMOR_STAND)) {
                ArmorStandManipulateListener.inspectHangingTransactions(armorStand.getLocation(), player);
            }
            event.setCancelled(true);
        }
        if (event.isCancelled()) {
            return;
        }
        if (!Config.getConfig((World)player.getWorld()).ITEM_TRANSACTIONS) {
            return;
        }
        int slot = 0;
        switch (event.getSlot()) {
            case LEGS: {
                slot = 1;
                break;
            }
            case CHEST: {
                slot = 2;
                break;
            }
            case HEAD: {
                slot = 3;
                break;
            }
            case HAND: {
                slot = 4;
                break;
            }
            case OFF_HAND: {
                slot = 5;
                break;
            }
            default: {
                slot = 0;
            }
        }
        if (item.getType() == playerItem.getType()) {
            return;
        }
        if (item.getType() != Material.AIR && playerItem.getType() == Material.AIR) {
            oldContents[slot] = item.clone();
            newContents[slot] = new ItemStack(Material.AIR);
            PlayerInteractEntityListener.queueContainerSpecifiedItems(player.getName(), Material.ARMOR_STAND, new Object[]{oldContents, newContents}, armorStand.getLocation(), false);
        } else if (item.getType() == Material.AIR && playerItem.getType() != Material.AIR) {
            oldContents[slot] = new ItemStack(Material.AIR);
            newContents[slot] = playerItem.clone();
            PlayerInteractEntityListener.queueContainerSpecifiedItems(player.getName(), Material.ARMOR_STAND, new Object[]{oldContents, newContents}, armorStand.getLocation(), false);
        } else if (item.getType() != Material.AIR && playerItem.getType() != Material.AIR) {
            oldContents[slot] = item.clone();
            newContents[slot] = playerItem.clone();
            PlayerInteractEntityListener.queueContainerSpecifiedItems(player.getName(), Material.ARMOR_STAND, new Object[]{oldContents, newContents}, armorStand.getLocation(), false);
        }
    }
}

