/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands;

import de.corneliusmay.silkspawners.plugin.commands.completers.OnlinePlayersTabCompleter;
import de.corneliusmay.silkspawners.plugin.commands.handler.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.commands.handler.StaticTabCompletion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class ExplosionCommand
extends SilkSpawnersCommand {
    public ExplosionCommand() {
        super("explosion", true, new StaticTabCompletion("enable", "disable", "setting"), new OnlinePlayersTabCompleter());
    }

    @Override
    protected boolean execute(CommandSender sender, String[] args) {
        if (args.length != 2) {
            return this.invalidSyntax(sender);
        }
        Player p = Bukkit.getPlayer((String)args[1]);
        if (p == null) {
            this.sendMessage(sender, "PLAYER_NOT_FOUND", args[1]);
            return false;
        }
        PermissionAttachment attachment = p.addAttachment((Plugin)this.plugin);
        switch (args[0].toLowerCase()) {
            case "enable": 
            case "e": {
                attachment.setPermission("silkspawners.explosion", true);
                this.sendMessage(sender, "ENABLED", p.getName());
                break;
            }
            case "disable": 
            case "d": {
                attachment.setPermission("silkspawners.explosion", false);
                this.sendMessage(sender, "DISABLED", p.getName());
                break;
            }
            case "setting": 
            case "s": {
                this.sendMessage(sender, "SETTING_" + (p.hasPermission("silkspawners.explosion") ? "ENABLED" : "DISABLED"), p.getName());
                break;
            }
            default: {
                this.invalidSyntax(sender);
            }
        }
        return true;
    }
}

