/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands.handler;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.commands.handler.SilkSpawnersCommandHandler;
import de.corneliusmay.silkspawners.plugin.commands.handler.TabCompletion;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class SilkSpawnersCommand {
    private SilkSpawnersCommandHandler commandHandler;
    protected SilkSpawners plugin;
    private final String command;
    private final TabCompletion[] completions;
    private final boolean requiresPermission;

    public SilkSpawnersCommand(String command, Boolean requiresPermission, TabCompletion ... completions) {
        this.command = command;
        this.requiresPermission = requiresPermission;
        this.completions = completions;
    }

    public final boolean hasPermission(CommandSender sender) {
        if (!this.requiresPermission) {
            return true;
        }
        return sender.hasPermission(this.getPermissionString());
    }

    public final String getPermissionString() {
        return this.commandHandler.getMainCommand() + ".command." + this.command;
    }

    private String getMessage(String key, Object ... args) {
        return this.plugin.getLocale().getMessage("COMMAND_" + this.commandHandler.getMainCommand().toUpperCase() + "_" + this.command.toUpperCase() + "_" + key, args);
    }

    protected final void sendMessage(CommandSender sender, String key, Object ... args) {
        sender.sendMessage(this.getMessage(key, args));
    }

    protected final void sendMessage(Player player, String key, Object ... args) {
        player.sendMessage(this.getMessage(key, args));
    }

    public boolean insufficientPermission(CommandSender sender) {
        sender.sendMessage(this.plugin.getLocale().getMessage("COMMAND_INSUFFICIENT_PERMISSIONS", new Object[0]));
        return false;
    }

    public boolean invalidSyntax(CommandSender sender) {
        this.sendMessage(sender, "USAGE", new Object[0]);
        return false;
    }

    protected abstract boolean execute(CommandSender var1, String[] var2);

    @Generated
    void setCommandHandler(SilkSpawnersCommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    @Generated
    void setPlugin(SilkSpawners plugin) {
        this.plugin = plugin;
    }

    @Generated
    String getCommand() {
        return this.command;
    }

    @Generated
    TabCompletion[] getCompletions() {
        return this.completions;
    }
}

