/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.listeners;

import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.events.SpawnerBreakEvent;
import de.corneliusmay.silkspawners.plugin.listeners.handler.SilkSpawnersListener;
import de.corneliusmay.silkspawners.plugin.spawner.Spawner;
import de.corneliusmay.silkspawners.plugin.utils.Explosion;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class BlockBreakListener
extends SilkSpawnersListener<BlockBreakEvent> {
    @Override
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onCall(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Spawner spawner = new Spawner(this.plugin, e.getBlock());
        if (!spawner.isValid()) {
            return;
        }
        Player p = e.getPlayer();
        if (!(p.hasPermission("silkspawners.break." + spawner.serializedEntityType()) || p.hasPermission("silkspawners.break.*") || ((Boolean)new ConfigValue(PluginConfig.SPAWNER_PERMISSION_DISABLE_DESTROY).get()).booleanValue())) {
            this.destroySpawner(p, e);
            return;
        }
        ItemStack[] itemsInHand = this.plugin.getBukkitHandler().getItemsInHand(p);
        if (!this.itemHasSilktouch(itemsInHand)) {
            this.destroySpawner(p, e);
            return;
        }
        int dropChance = (Integer)new ConfigValue(PluginConfig.SPAWNER_DROP_CHANCE).get();
        if (Math.random() > (double)((float)dropChance / 100.0f)) {
            this.destroySpawner(p, e);
            return;
        }
        SpawnerBreakEvent event = new SpawnerBreakEvent(p, spawner, e.getBlock().getLocation(), this.plugin);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.setCancelled(true);
            return;
        }
        e.setExpToDrop(0);
        p.getWorld().dropItemNaturally(e.getBlock().getLocation(), event.getSpawner().getItemStack());
    }

    private void destroySpawner(Player p, BlockBreakEvent e) {
        if (!((Boolean)new ConfigValue(PluginConfig.SPAWNER_DESTROYABLE).get()).booleanValue()) {
            e.setCancelled(true);
            if (((Boolean)new ConfigValue(PluginConfig.SPAWNER_MESSAGE_DENY_DESTROY).get()).booleanValue()) {
                p.sendMessage(this.plugin.getLocale().getMessage("SPAWNER_DESTROY_DENIED", new Object[0]));
            }
        } else {
            new Explosion(p, e.getBlock().getWorld(), e.getBlock().getLocation(), (Integer)new ConfigValue(PluginConfig.SPAWNER_EXPLOSION_NORMAL).get());
        }
    }

    private boolean itemHasSilktouch(ItemStack[] items) {
        return this.itemHasSilktouch(items, 0);
    }

    private boolean itemHasSilktouch(ItemStack[] items, int i) {
        boolean hasSilktouch;
        if (items.length == i) {
            return false;
        }
        boolean isPickaxe = items[i].getType().toString().contains("PICKAXE") || (Boolean)new ConfigValue(PluginConfig.SPAWNER_PICKAXE_REQUIRED).get() == false;
        boolean bl = hasSilktouch = items[i].containsEnchantment(Enchantment.SILK_TOUCH) || (Boolean)new ConfigValue(PluginConfig.SPAWNER_SILKTOUCH_REQUIRED).get() == false;
        if (isPickaxe && hasSilktouch) {
            return true;
        }
        return this.itemHasSilktouch(items, i + 1);
    }
}

