/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.listeners;

import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.listeners.handler.SilkSpawnersListener;
import de.corneliusmay.silkspawners.plugin.spawner.Spawner;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerInteractListener
extends SilkSpawnersListener<PlayerInteractEvent> {
    private final List<Block> editedSpawners;

    public PlayerInteractListener(List<Block> editedSpawners) {
        this.editedSpawners = editedSpawners;
    }

    @Override
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onCall(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        Location blockLocation = block.getLocation();
        Spawner spawner = new Spawner(this.plugin, block);
        if (!spawner.isValid()) {
            return;
        }
        if (this.editedSpawners.stream().anyMatch(b -> b.getLocation().equals((Object)blockLocation))) {
            e.setCancelled(true);
            return;
        }
        this.editedSpawners.add(block);
        this.plugin.getPlatform().runTaskLater(blockLocation, () -> {
            Spawner newSpawner = new Spawner(this.plugin, block.getWorld().getBlockAt(blockLocation));
            if (!(e.getPlayer().hasPermission("silkspawners.change." + newSpawner.serializedEntityType()) || e.getPlayer().hasPermission("silkspawners.change.*") || ((Boolean)new ConfigValue(PluginConfig.SPAWNER_PERMISSION_DISABLE_CHANGE).get()).booleanValue() || spawner.getEntityType() == newSpawner.getEntityType())) {
                spawner.setSpawnerBlockType(block, this.editedSpawners);
                if (((Boolean)new ConfigValue(PluginConfig.SPAWNER_MESSAGE_DENY_CHANGE).get()).booleanValue()) {
                    e.getPlayer().sendMessage(this.plugin.getLocale().getMessage("SPAWNER_CHANGE_DENIED", new Object[0]));
                }
            } else {
                this.editedSpawners.remove(block);
            }
        }, 1L);
    }
}

