/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.locale;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import lombok.Generated;
import org.bukkit.plugin.Plugin;

public class LocaleHandler {
    private static final String DEFAULT_MESSAGE = "\u00a7cNo value found for key {0} using locale {1}.\u00a77\n Use \u00a7l\u00a7n/silkspawners locale update confirm\u00a77 to update the locale files.\n \u00a7eWarning!\u00a77 Updating the locale files will overwrite all changes\u00a77.";
    private final SilkSpawners plugin;
    private final File localePath;
    private final Locale locale;
    private ResourceBundle resourceBundle;

    public LocaleHandler(SilkSpawners plugin, Locale locale) {
        this.plugin = plugin;
        this.locale = locale;
        this.localePath = new File(plugin.getDataFolder() + "/locale");
        try {
            this.copyDefaultLocales(false);
            this.loadLocale();
        }
        catch (IOException | URISyntaxException | MissingResourceException ex) {
            plugin.getLog().error("Error loading locale file", ex);
            plugin.getLog().warn("Disabling plugin due to missing locale file");
            plugin.getLog().info("Available locales: " + this.getAvailableLocales());
            plugin.getPluginLoader().disablePlugin((Plugin)plugin);
        }
    }

    public void copyDefaultLocales(final boolean overwrite) throws URISyntaxException, IOException {
        final Path target = Paths.get(this.plugin.getDataFolder() + "/locale", new String[0]);
        URI resource = this.getClass().getResource("").toURI();
        FileSystem fileSystem = FileSystems.newFileSystem(resource, Collections.emptyMap());
        final Path jarPath = fileSystem.getPath("/locales", new String[0]);
        Files.walkFileTree(jarPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(jarPath.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = target.resolve(jarPath.relativize(file).toString());
                if (overwrite) {
                    Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                } else if (Files.notExists(targetFile, new LinkOption[0])) {
                    Files.copy(file, targetFile, new CopyOption[0]);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        fileSystem.close();
    }

    public void loadLocale() throws MalformedURLException {
        URL[] urls = new URL[]{this.localePath.toURI().toURL()};
        URLClassLoader loader = new URLClassLoader(urls);
        this.resourceBundle = ResourceBundle.getBundle("messages", this.locale, loader);
    }

    public String getAvailableLocales() {
        File localesDir = new File(this.plugin.getDataFolder() + "/locale");
        return Arrays.stream(localesDir.listFiles()).sorted().map(f -> f.getName().replace("messages_", "").replace(".properties", "")).toList().toString().replace("[", "").replace("]", "");
    }

    public String getMessageClean(String key, Object ... args) {
        return MessageFormat.format(this.resourceBundle.getString(key).replace("$", "\u00a7"), args);
    }

    public String getMessage(String key, Object ... args) {
        try {
            return LocaleHandler.getPrefix() + "\u00a7f " + this.getMessageClean(key, args);
        }
        catch (MissingResourceException ex) {
            return LocaleHandler.getPrefix() + "\u00a7f " + MessageFormat.format(DEFAULT_MESSAGE, key, this.locale.toString());
        }
    }

    public static String getPrefix() {
        return (String)new ConfigValue(PluginConfig.MESSAGE_PREFIX).get();
    }

    @Generated
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

