/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.spawner;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValueArray;
import de.corneliusmay.silkspawners.plugin.utils.ItemBuilder;
import de.corneliusmay.silkspawners.plugin.utils.StringUtils;
import java.util.List;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class Spawner {
    public static String EMPTY = "empty";
    private final SilkSpawners plugin;
    private EntityType entityType;
    private ItemStack itemStack;
    private final String prefix = (String)new ConfigValue(PluginConfig.SPAWNER_ITEM_PREFIX).get();
    private final String oldPrefix = (String)new ConfigValue(PluginConfig.SPAWNER_ITEM_PREFIX_OLD).get();

    public Spawner(SilkSpawners plugin, Block block) {
        this.plugin = plugin;
        if (block == null) {
            return;
        }
        if (block.getType() != this.plugin.getBukkitHandler().getSpawnerMaterial()) {
            return;
        }
        CreatureSpawner creatureSpawner = (CreatureSpawner)block.getState();
        this.entityType = creatureSpawner.getSpawnedType();
        this.itemStack = this.generateItemStack();
    }

    public Spawner(SilkSpawners plugin, ItemStack itemStack) {
        this.plugin = plugin;
        this.itemStack = itemStack;
        if (itemStack == null) {
            return;
        }
        if (itemStack.getType() != this.plugin.getBukkitHandler().getSpawnerMaterial()) {
            return;
        }
        if (itemStack.getItemMeta() == null || itemStack.getItemMeta().getLore() == null) {
            return;
        }
        this.entityType = this.getSpawnerEntity((String)itemStack.getItemMeta().getLore().get(0));
    }

    public Spawner(SilkSpawners plugin, EntityType entityType) {
        this.plugin = plugin;
        this.entityType = entityType;
        this.itemStack = this.generateItemStack();
    }

    public void setSpawnerBlockType(Block block, List<Block> editedList) {
        if (!this.isValid()) {
            editedList.remove(block);
            return;
        }
        this.plugin.getPlatform().runTaskLater(block.getLocation(), () -> {
            BlockState blockState = block.getState();
            if (!(blockState instanceof CreatureSpawner)) {
                return;
            }
            CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
            creatureSpawner.setSpawnedType(this.entityType);
            blockState.update();
            editedList.remove(block);
        }, 1L);
    }

    private ItemStack generateItemStack() {
        return new ItemBuilder(this.plugin.getBukkitHandler().getSpawnerMaterial()).setDisplayName((String)new ConfigValue(PluginConfig.SPAWNER_ITEM_NAME).get()).addToLore(this.serializedName()).addToLore(new ConfigValueArray(PluginConfig.SPAWNER_ITEM_LORE).get()).build();
    }

    private EntityType getSpawnerEntity(String lore) {
        String name;
        if (lore.startsWith(this.prefix)) {
            name = lore.replaceFirst(this.prefix, "").replace(" ", "_").toLowerCase();
        } else if (!this.oldPrefix.equals("") && lore.startsWith(this.oldPrefix)) {
            name = lore.replaceFirst(this.oldPrefix, "").replace(" ", "_").toLowerCase();
        } else {
            return null;
        }
        if (name.equalsIgnoreCase(EMPTY)) {
            return null;
        }
        return EntityType.fromName((String)name);
    }

    public String serializedEntityType() {
        return this.entityType == null ? EMPTY : this.entityType.getName().toLowerCase();
    }

    public String serializedName() {
        return this.prefix + StringUtils.capitalizeFully(this.serializedEntityType().replace("_", " "));
    }

    public boolean isValid() {
        return this.itemStack != null && (this.entityType == null || this.entityType.isSpawnable());
    }

    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

