/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public enum XPotion {
    ABSORPTION("ABSORB"),
    BAD_OMEN("OMEN_BAD", "PILLAGER"),
    BLINDNESS("BLIND"),
    CONDUIT_POWER("CONDUIT", "POWER_CONDUIT"),
    CONFUSION("NAUSEA", "SICKNESS", "SICK"),
    DAMAGE_RESISTANCE("RESISTANCE", "ARMOR", "DMG_RESIST", "DMG_RESISTANCE"),
    DARKNESS(new String[0]),
    DOLPHINS_GRACE("DOLPHIN", "GRACE"),
    FAST_DIGGING("HASTE", "SUPER_PICK", "DIGFAST", "DIG_SPEED", "QUICK_MINE", "SHARP"),
    FIRE_RESISTANCE("FIRE_RESIST", "RESIST_FIRE", "FIRE_RESISTANCE"),
    GLOWING("GLOW", "SHINE", "SHINY"),
    HARM("INJURE", "DAMAGE", "HARMING", "INFLICT", "INSTANT_DAMAGE"),
    HEAL("HEALTH", "INSTA_HEAL", "INSTANT_HEAL", "INSTA_HEALTH", "INSTANT_HEALTH"),
    HEALTH_BOOST("BOOST_HEALTH", "BOOST", "HP"),
    HERO_OF_THE_VILLAGE("HERO", "VILLAGE_HERO"),
    HUNGER("STARVE", "HUNGRY"),
    INCREASE_DAMAGE("STRENGTH", "BULL", "STRONG", "ATTACK"),
    INVISIBILITY("INVISIBLE", "VANISH", "INVIS", "DISAPPEAR", "HIDE"),
    JUMP("LEAP", "JUMP_BOOST"),
    LEVITATION("LEVITATE"),
    LUCK("LUCKY"),
    NIGHT_VISION("VISION", "VISION_NIGHT"),
    POISON("VENOM"),
    REGENERATION("REGEN"),
    SATURATION("FOOD"),
    SLOW("SLOWNESS", "SLUGGISH"),
    SLOW_DIGGING("FATIGUE", "DULL", "DIGGING", "SLOW_DIG", "DIG_SLOW"),
    SLOW_FALLING("SLOW_FALL", "FALL_SLOW"),
    SPEED("SPRINT", "RUNFAST", "SWIFT", "FAST"),
    UNLUCK("UNLUCKY"),
    WATER_BREATHING("WATER_BREATH", "UNDERWATER_BREATHING", "UNDERWATER_BREATH", "AIR"),
    WEAKNESS("WEAK"),
    WITHER("DECAY");

    public static final XPotion[] VALUES;
    public static final Set<XPotion> DEBUFFS;
    private static final XPotion[] POTIONEFFECTTYPE_MAPPING;
    private final PotionEffectType type = PotionEffectType.getByName((String)this.name());

    private XPotion(String ... aliases) {
        Data.NAMES.put(this.name(), this);
        for (String legacy : aliases) {
            Data.NAMES.put(legacy, this);
        }
    }

    @Nonnull
    private static String format(@Nonnull String name) {
        int len = name.length();
        char[] chs = new char[len];
        int count = 0;
        boolean appendUnderline = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (!(appendUnderline || count == 0 || ch != '-' && ch != ' ' && ch != '_' || chs[count] == '_')) {
                appendUnderline = true;
                continue;
            }
            if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            if (appendUnderline) {
                chs[count++] = 95;
                appendUnderline = false;
            }
            chs[count++] = (char)(ch & 0x5F);
        }
        return new String(chs, 0, count);
    }

    @Nonnull
    public static Optional<XPotion> matchXPotion(@Nonnull String potion) {
        if (potion == null || potion.isEmpty()) {
            throw new IllegalArgumentException("Cannot match XPotion of a null or empty potion effect type");
        }
        PotionEffectType idType = XPotion.fromId(potion);
        if (idType != null) {
            XPotion type = (XPotion)((Object)Data.NAMES.get(idType.getName()));
            if (type == null) {
                throw new NullPointerException("Unsupported potion effect type ID: " + idType);
            }
            return Optional.of(type);
        }
        return Optional.ofNullable((XPotion)((Object)Data.NAMES.get(XPotion.format(potion))));
    }

    @Nonnull
    public static XPotion matchXPotion(@Nonnull PotionEffectType type) {
        Objects.requireNonNull(type, "Cannot match XPotion of a null potion effect type");
        return POTIONEFFECTTYPE_MAPPING[type.getId()];
    }

    @Nullable
    private static PotionEffectType fromId(@Nonnull String type) {
        try {
            int id = Integer.parseInt(type);
            return PotionEffectType.getById((int)id);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static List<String> split(@Nonnull String str, char separatorChar) {
        ArrayList<String> list = new ArrayList<String>(5);
        boolean match = false;
        boolean lastMatch = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = i + 1;
                continue;
            }
            lastMatch = false;
            match = true;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, len));
        }
        return list;
    }

    @Nullable
    public static Effect parseEffect(@Nullable String potion) {
        Optional<XPotion> typeOpt;
        if (Strings.isNullOrEmpty((String)potion) || potion.equalsIgnoreCase("none")) {
            return null;
        }
        List<String> split = XPotion.split(potion.replace(" ", ""), ',');
        if (split.isEmpty()) {
            split = XPotion.split(potion, ' ');
        }
        double chance = 100.0;
        int chanceIndex = 0;
        if (split.size() > 2 && (chanceIndex = split.get(2).indexOf(37)) != -1) {
            try {
                chance = Double.parseDouble(split.get(2).substring(chanceIndex + 1));
            }
            catch (NumberFormatException ex) {
                chance = 100.0;
            }
        }
        if (!(typeOpt = XPotion.matchXPotion(split.get(0))).isPresent()) {
            return null;
        }
        PotionEffectType type = typeOpt.get().type;
        if (type == null) {
            return null;
        }
        int duration = 2400;
        int amplifier = 0;
        if (split.size() > 1) {
            duration = XPotion.toInt(split.get(1), 1) * 20;
            if (split.size() > 2) {
                amplifier = XPotion.toInt(chanceIndex <= 0 ? split.get(2) : split.get(2).substring(0, chanceIndex), 1) - 1;
            }
        }
        return new Effect(new PotionEffect(type, duration, amplifier), chance);
    }

    private static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static void addEffects(@Nonnull LivingEntity entity, @Nullable List<String> effects) {
        Objects.requireNonNull(entity, "Cannot add potion effects to null entity");
        for (Effect effect : XPotion.parseEffects(effects)) {
            effect.apply(entity);
        }
    }

    public static List<Effect> parseEffects(@Nullable List<String> effectsString) {
        if (effectsString == null || effectsString.isEmpty()) {
            return new ArrayList<Effect>();
        }
        ArrayList<Effect> effects = new ArrayList<Effect>(effectsString.size());
        for (String effectStr : effectsString) {
            Effect effect = XPotion.parseEffect(effectStr);
            if (effect == null) continue;
            effects.add(effect);
        }
        return effects;
    }

    @Nonnull
    public static ThrownPotion throwPotion(@Nonnull LivingEntity entity, @Nullable Color color, PotionEffect ... effects) {
        Objects.requireNonNull(entity, "Cannot throw potion from null entity");
        ItemStack potion = Material.getMaterial((String)"SPLASH_POTION") == null ? new ItemStack(Material.POTION, 1, 16398) : new ItemStack(Material.SPLASH_POTION);
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        meta.setColor(color);
        if (effects != null) {
            for (PotionEffect effect : effects) {
                meta.addCustomEffect(effect, true);
            }
        }
        potion.setItemMeta((ItemMeta)meta);
        ThrownPotion thrownPotion = (ThrownPotion)entity.launchProjectile(ThrownPotion.class);
        thrownPotion.setItem(potion);
        return thrownPotion;
    }

    @Nonnull
    public static ItemStack buildItemWithEffects(@Nonnull Material type, @Nullable Color color, PotionEffect ... effects) {
        Objects.requireNonNull(type, "Cannot build an effected item with null type");
        if (!XPotion.canHaveEffects(type)) {
            throw new IllegalArgumentException("Cannot build item with " + type.name() + " potion type");
        }
        ItemStack item = new ItemStack(type);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        meta.setColor(color);
        meta.setDisplayName(type == Material.POTION ? "Potion" : (type == Material.SPLASH_POTION ? "Splash Potion" : (type == Material.TIPPED_ARROW ? "Tipped Arrow" : "Lingering Potion")));
        if (effects != null) {
            for (PotionEffect effect : effects) {
                meta.addCustomEffect(effect, true);
            }
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static boolean canHaveEffects(@Nullable Material material) {
        return material != null && (material.name().endsWith("POTION") || material.name().startsWith("TIPPED_ARROW"));
    }

    @Nullable
    public PotionEffectType getPotionEffectType() {
        return this.type;
    }

    public boolean isSupported() {
        return this.type != null;
    }

    @Nullable
    @Deprecated
    public PotionType getPotionType() {
        return this.type == null ? null : PotionType.getByEffect((PotionEffectType)this.type);
    }

    @Nullable
    public PotionEffect buildPotionEffect(int duration, int amplifier) {
        return this.type == null ? null : new PotionEffect(this.type, duration, amplifier);
    }

    public String toString() {
        return Arrays.stream(this.name().split("_")).map(t -> t.charAt(0) + t.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    static {
        VALUES = XPotion.values();
        DEBUFFS = Collections.unmodifiableSet(EnumSet.of(BAD_OMEN, new XPotion[]{BLINDNESS, CONFUSION, HARM, HUNGER, LEVITATION, POISON, SLOW, SLOW_DIGGING, UNLUCK, WEAKNESS, WITHER}));
        POTIONEFFECTTYPE_MAPPING = new XPotion[VALUES.length + 1];
        for (XPotion pot : VALUES) {
            if (pot.type == null) continue;
            XPotion.POTIONEFFECTTYPE_MAPPING[pot.type.getId()] = pot;
        }
    }

    private static final class Data {
        private static final Map<String, XPotion> NAMES = new HashMap<String, XPotion>();

        private Data() {
        }
    }

    public static class Effect {
        private PotionEffect effect;
        private double chance;

        public Effect(PotionEffect effect, double chance) {
            this.effect = effect;
            this.chance = chance;
        }

        public XPotion getXPotion() {
            return XPotion.matchXPotion(this.effect.getType());
        }

        public double getChance() {
            return this.chance;
        }

        public boolean hasChance() {
            return this.chance >= 100.0 || ThreadLocalRandom.current().nextDouble(0.0, 100.0) <= this.chance;
        }

        public void setChance(double chance) {
            this.chance = chance;
        }

        public void apply(LivingEntity entity) {
            if (this.hasChance()) {
                entity.addPotionEffect(this.effect);
            }
        }

        public PotionEffect getEffect() {
            return this.effect;
        }

        public void setEffect(PotionEffect effect) {
            this.effect = effect;
        }
    }
}

