/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.chunkloader;

import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.kayteam.chunkloader.chunk.ChunkManager;
import org.kayteam.chunkloader.commands.Command_AddChunk;
import org.kayteam.chunkloader.commands.Command_AddChunkRegion;
import org.kayteam.chunkloader.commands.Command_ChunkLoader;
import org.kayteam.chunkloader.commands.Command_RemoveChunk;
import org.kayteam.chunkloader.commands.Command_RemoveChunkRegion;
import org.kayteam.chunkloader.listeners.ChunkUnloadListener;
import org.kayteam.chunkloader.listeners.PlayerJoinListener;
import org.kayteam.chunkloader.util.Metrics;
import org.kayteam.chunkloader.util.UpdateChecker;
import org.kayteam.inventoryapi.InventoryManager;
import org.kayteam.storageapi.storage.YML;
import org.kayteam.storageapi.storage.Yaml;
import org.kayteam.storageapi.utils.BrandSender;

public class ChunkLoader
extends JavaPlugin {
    private static ChunkLoader instance;
    private static ChunkManager chunkManager;
    public static YML messages;
    private static YML messages_es;
    private static YML messages_en;
    private static YML messages_ru;
    private static YML messages_fr;
    public static YML data;
    public static YML config;
    public static final String logPrefix = "&2Chunk&aLoader &7>> &f";
    private static String lang;
    private static UpdateChecker updateChecker;
    private static InventoryManager inventoryManager;

    public void onEnable() {
        ChunkLoader.initializeInstance(this);
        ChunkLoader.enablePluginUpdateChecker();
        this.checkPaper();
        ChunkLoader.registerFiles();
        ChunkLoader.loadConfig();
        ChunkLoader.loadMessages();
        this.registerCommands();
        this.enableBStats();
        this.registerListeners();
        this.loadAll();
        inventoryManager.registerManager();
        BrandSender.onEnable(this);
    }

    private static void initializeInstance(ChunkLoader plugin) {
        instance = plugin;
        chunkManager = new ChunkManager();
        inventoryManager = new InventoryManager(plugin);
    }

    private static void loadConfig() {
        if (config.contains("chunk-load")) {
            ChunkLoader.chunkManager.chunkLoad = config.getBoolean("chunk-load", true);
        } else {
            config.set("chunk-load", true);
            config.save();
        }
        if (config.contains("log-chunk-load")) {
            ChunkLoader.chunkManager.chunkLoadLogs = config.getBoolean("log-chunk-load", true);
        } else {
            config.set("log-chunk-load", true);
            config.save();
        }
        if (config.contains("updateChecker")) {
            ChunkLoader.chunkManager.updateChecker = config.getBoolean("update-checker", true);
        } else {
            config.set("update-checker", true);
            config.save();
        }
        if (config.contains("lang")) {
            lang = config.getString("lang", "en");
        } else {
            config.set("lang", "en");
            config.save();
        }
    }

    public static ChunkManager getChunkManager() {
        return chunkManager;
    }

    private static void loadMessages() {
        try {
            messages = new YML(instance, "messages_" + lang);
            messages.register();
            Yaml.sendSimpleMessage((CommandSender)instance.getServer().getConsoleSender(), messages_en.getString("logs.messages"), new String[][]{{"%lang%", "messages_" + lang}});
        }
        catch (Exception e) {
            Yaml.sendSimpleMessage((CommandSender)instance.getServer().getConsoleSender(), messages_en.getString("logs.messages-error"), new String[][]{{"%lang%", "messages_" + lang}});
        }
    }

    private static void registerFiles() {
        messages_es = new YML(instance, "messages_es");
        messages_es.register();
        messages_en = new YML(instance, "messages_en");
        messages_en.register();
        messages_ru = new YML(instance, "messages_ru");
        messages_ru.register();
        messages_fr = new YML(instance, "messages_fr");
        messages_fr.register();
        config = new YML(instance, "config");
        config.register();
        data = new YML(instance, "data");
        data.register();
    }

    private static void enablePluginUpdateChecker() {
        updateChecker = new UpdateChecker(instance, 92834);
        if (updateChecker.getUpdateCheckResult().equals((Object)UpdateChecker.UpdateCheckResult.OUT_DATED)) {
            updateChecker.sendOutDatedMessage((CommandSender)instance.getServer().getConsoleSender());
        }
    }

    public static UpdateChecker getUpdateChecker() {
        return updateChecker;
    }

    public static InventoryManager getInventoryManager() {
        return inventoryManager;
    }

    private void enableBStats() {
        int pluginId = 12091;
        new Metrics(this, pluginId);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ChunkUnloadListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
    }

    private void loadAll() {
        if (chunkManager.isChunkLoad()) {
            chunkManager.enableChunkLoad();
        }
    }

    private void checkPaper() {
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            ChunkLoader.getChunkManager().setPaperState(true);
        }
        catch (ClassNotFoundException ignored) {
            ChunkLoader.getChunkManager().setPaperState(false);
        }
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("addchunk")).setExecutor((CommandExecutor)new Command_AddChunk());
        if (chunkManager.isWorldEdit()) {
            Objects.requireNonNull(this.getCommand("addchunkregion")).setExecutor((CommandExecutor)new Command_AddChunkRegion());
            Objects.requireNonNull(this.getCommand("removechunkregion")).setExecutor((CommandExecutor)new Command_RemoveChunkRegion());
        }
        Objects.requireNonNull(this.getCommand("removechunk")).setExecutor((CommandExecutor)new Command_RemoveChunk());
        Objects.requireNonNull(this.getCommand("chunkloader")).setExecutor((CommandExecutor)new Command_ChunkLoader());
    }

    public static ChunkLoader getInstance() {
        return instance;
    }

    public void onDisable() {
        BrandSender.onDisable(this);
    }
}

