/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.chunkloader.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.kayteam.chunkloader.ChunkLoader;
import org.kayteam.chunkloader.commands.Command_Help;
import org.kayteam.chunkloader.commands.Command_List;
import org.kayteam.chunkloader.commands.Command_Menu;
import org.kayteam.chunkloader.commands.Command_Off;
import org.kayteam.chunkloader.commands.Command_On;
import org.kayteam.chunkloader.commands.Command_Reload;
import org.kayteam.chunkloader.commands.Command_TP;
import org.kayteam.chunkloader.util.PermissionChecker;
import org.kayteam.storageapi.storage.Yaml;

public class Command_ChunkLoader
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("help")) {
                    new Command_Help().chunkHelp(player);
                } else if (args[0].equalsIgnoreCase("list")) {
                    if (PermissionChecker.check((CommandSender)player, "chunkloader.list")) {
                        new Command_List().chunkList(player);
                    }
                } else if (args[0].equalsIgnoreCase("reload")) {
                    if (PermissionChecker.check((CommandSender)player, "chunkloader.reload")) {
                        new Command_Reload().commandReload(player);
                    }
                } else if (args[0].equalsIgnoreCase("on")) {
                    if (PermissionChecker.check((CommandSender)player, "chunkloader.on")) {
                        new Command_On().enableChunkLoad(player);
                    }
                } else if (args[0].equalsIgnoreCase("off")) {
                    if (PermissionChecker.check((CommandSender)player, "chunkloader.off")) {
                        new Command_Off().disableChunkLoad(player);
                    }
                } else if (args[0].equalsIgnoreCase("tp")) {
                    if (PermissionChecker.check((CommandSender)player, "chunkloader.tp")) {
                        if (args.length > 1) {
                            try {
                                new Command_TP().chunkTeleport(player, Integer.parseInt(args[1]));
                            }
                            catch (Exception exception) {}
                        } else {
                            Yaml.sendSimpleMessage((CommandSender)player, "&c/cl tp <list-number>");
                        }
                    }
                } else if (args[0].equalsIgnoreCase("menu")) {
                    if (PermissionChecker.check((CommandSender)player, "chunkloader.menu")) {
                        new Command_Menu().openMenu(player);
                    }
                } else {
                    new Command_Help().chunkHelp(player);
                }
            } else {
                new Command_Help().chunkHelp(player);
            }
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender s, @NotNull Command c, @NotNull String label, String[] args) {
        ArrayList<String> tabs = new ArrayList<String>();
        if (args.length == 1) {
            tabs.add("help");
            tabs.add("list");
            tabs.add("menu");
            tabs.add("on");
            tabs.add("off");
            tabs.add("tp");
            tabs.add("reload");
            return tabs;
        }
        if (args.length == 2 && args[0].equals("tp")) {
            for (int i = 0; i < ChunkLoader.getChunkManager().getChunkList().size(); ++i) {
                tabs.add(String.valueOf(i));
            }
            return tabs;
        }
        return null;
    }
}

