/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.chunkloader.commands;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.kayteam.chunkloader.ChunkLoader;
import org.kayteam.chunkloader.chunk.ChunkManager;

public class Command_RemoveChunkRegion
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (sender instanceof Player) {
            try {
                ChunkManager chunkManager = ChunkLoader.getChunkManager();
                Player player = (Player)sender;
                if (!player.hasPermission("chunkloader.removechunkregion")) {
                    ChunkLoader.messages.sendMessage((CommandSender)player, "command.no-permission");
                    return false;
                }
                if (!chunkManager.isWorldEdit()) {
                    ChunkLoader.messages.sendMessage((CommandSender)player, "command.worldedit-disabled");
                    return false;
                }
                BukkitPlayer bPlayer = BukkitAdapter.adapt((Player)player);
                LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)bPlayer);
                Region sel = session.getSelection(bPlayer.getWorld());
                BlockVector3 max = sel.getMaximumPoint();
                BlockVector3 min = sel.getMinimumPoint();
                Location maxPoint = new Location(player.getWorld(), (double)max.getBlockX(), (double)max.getBlockY(), (double)max.getBlockZ());
                Location minPoint = new Location(player.getWorld(), (double)min.getBlockX(), (double)min.getBlockY(), (double)min.getBlockZ());
                Chunk chunkMax = maxPoint.getChunk();
                Chunk chunkMin = minPoint.getChunk();
                int maxZ = chunkMax.getZ();
                int maxX = chunkMax.getX();
                int minX = chunkMin.getX();
                int minZ = chunkMin.getZ();
                String world = sel.getWorld().getName();
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Chunk chunk = player.getWorld().getChunkAt(x, z);
                        if (ChunkLoader.getChunkManager().getChunkList().contains(chunk)) continue;
                        ChunkLoader.getChunkManager().deleteChunk(chunk, player);
                    }
                }
                ChunkLoader.messages.sendMessage(sender, "chunkloader.region-removed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

