/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.inventoryapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.kayteam.inventoryapi.InventoryBuilder;
import org.kayteam.inventoryapi.InventoryUpdater;
import org.kayteam.inventoryapi.listeners.InventoryClickListener;
import org.kayteam.inventoryapi.listeners.InventoryCloseListener;
import org.kayteam.inventoryapi.listeners.PlayerQuitListener;

public class InventoryManager {
    private final JavaPlugin javaPlugin;
    private final HashMap<UUID, InventoryBuilder> openedInventories = new HashMap();

    public InventoryManager(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
    }

    public JavaPlugin getJavaPlugin() {
        return this.javaPlugin;
    }

    public void registerManager() {
        Server server = this.javaPlugin.getServer();
        PluginManager pluginManager = server.getPluginManager();
        pluginManager.registerEvents((Listener)new InventoryClickListener(this), (Plugin)this.javaPlugin);
        pluginManager.registerEvents((Listener)new InventoryCloseListener(this), (Plugin)this.javaPlugin);
        pluginManager.registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this.javaPlugin);
        ConsoleCommandSender console = server.getConsoleSender();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("&f");
        strings.add("&f &7" + this.javaPlugin.getName() + " &6use &7InventoryAPI developed by KayTeam");
        strings.add("&f");
        strings.add("&f &6Website: &7https://kayteam.org");
        strings.add("&f &6Github: &7https://github.com/KayTeam-Studio/inventory-api");
        strings.add("&f");
        for (String string : strings) {
            console.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        }
    }

    public HashMap<UUID, InventoryBuilder> getOpenedInventories() {
        return this.openedInventories;
    }

    public boolean containInventoryBuilder(InventoryBuilder inventoryBuilder) {
        return this.openedInventories.containsValue(inventoryBuilder);
    }

    public boolean containInventoryBuilder(Player player) {
        return this.openedInventories.containsKey(player.getUniqueId());
    }

    public InventoryBuilder getInventoryBuilder(Player player) {
        return this.openedInventories.get(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory(Player player, InventoryBuilder inventoryBuilder) {
        UUID uuid = player.getUniqueId();
        try {
            player.closeInventory();
        }
        catch (IllegalStateException inventory) {
        }
        finally {
            this.openedInventories.put(uuid, inventoryBuilder);
            Inventory inventory = Bukkit.createInventory(null, (int)(inventoryBuilder.getRows() * 9), (String)inventoryBuilder.getTitle());
            inventoryBuilder.setInventory(inventory);
            Server server = this.javaPlugin.getServer();
            BukkitScheduler bukkitScheduler = server.getScheduler();
            bukkitScheduler.runTaskLater((Plugin)this.javaPlugin, () -> {
                player.openInventory(inventory);
                inventoryBuilder.onReload();
            }, 1L);
            if (inventoryBuilder.getUpdateInterval() > 0) {
                InventoryUpdater inventoryUpdater = new InventoryUpdater(this, inventoryBuilder);
                long updateInterval = (long)inventoryBuilder.getUpdateInterval() * 20L;
                inventoryUpdater.runTaskTimer((Plugin)this.javaPlugin, 0L, updateInterval);
            }
        }
    }
}

