/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.nbtapi;

import org.kayteam.nbtapi.NBTCompound;
import org.kayteam.nbtapi.NBTList;
import org.kayteam.nbtapi.NBTListCompound;
import org.kayteam.nbtapi.NBTType;
import org.kayteam.nbtapi.NbtApiException;
import org.kayteam.nbtapi.utils.MinecraftVersion;
import org.kayteam.nbtapi.utils.nmsmappings.ClassWrapper;
import org.kayteam.nbtapi.utils.nmsmappings.ReflectionMethod;

public class NBTCompoundList
extends NBTList<NBTListCompound> {
    protected NBTCompoundList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    public NBTListCompound addCompound() {
        return (NBTListCompound)this.addCompound(null);
    }

    public NBTCompound addCompound(NBTCompound comp) {
        try {
            Object compound = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, this.size(), compound);
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, compound);
            }
            this.getParent().saveCompound();
            NBTListCompound listcomp = new NBTListCompound(this, compound);
            if (comp != null) {
                listcomp.mergeCompound(comp);
            }
            return listcomp;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    @Deprecated
    public boolean add(NBTListCompound empty) {
        return this.addCompound(empty) != null;
    }

    @Override
    public void add(int index, NBTListCompound element) {
        if (element != null) {
            throw new NbtApiException("You need to pass null! ListCompounds from other lists won't work.");
        }
        try {
            Object compound = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_14_R1.getVersionId()) {
                ReflectionMethod.LIST_ADD.run(this.listObject, index, compound);
            } else {
                ReflectionMethod.LEGACY_LIST_ADD.run(this.listObject, compound);
            }
            super.getParent().saveCompound();
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public NBTListCompound get(int index) {
        try {
            Object compound = ReflectionMethod.LIST_GET_COMPOUND.run(this.listObject, index);
            return new NBTListCompound(this, compound);
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public NBTListCompound set(int index, NBTListCompound element) {
        throw new NbtApiException("This method doesn't work in the ListCompound context.");
    }

    @Override
    protected Object asTag(NBTListCompound object) {
        return null;
    }
}

