/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.nbtapi;

import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.kayteam.nbtapi.NBTCompound;
import org.kayteam.nbtapi.NBTContainer;
import org.kayteam.nbtapi.NBTReflectionUtil;
import org.kayteam.nbtapi.NbtApiException;
import org.kayteam.nbtapi.utils.MinecraftVersion;
import org.kayteam.nbtapi.utils.annotations.AvailableSince;
import org.kayteam.nbtapi.utils.annotations.CheckUtil;
import org.kayteam.nbtapi.utils.annotations.FAUtil;

public class NBTTileEntity
extends NBTCompound {
    private final BlockState tile;

    public NBTTileEntity(BlockState tile) {
        super(null, null);
        if (tile == null || MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_8_R3) && !tile.isPlaced()) {
            throw new NullPointerException("Tile can't be null/not placed!");
        }
        this.tile = tile;
    }

    @Override
    public Object getCompound() {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("BlockEntity NBT needs to be accessed sync!");
        }
        return NBTReflectionUtil.getTileEntityNBTTagCompound(this.tile);
    }

    @Override
    protected void setCompound(Object compound) {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("BlockEntity NBT needs to be accessed sync!");
        }
        NBTReflectionUtil.setTileEntityNBTTagCompound(this.tile, compound);
    }

    @AvailableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("PublicBukkitValues").booleanValue()) {
            return this.getCompound("PublicBukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("PublicBukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("PublicBukkitValues");
    }
}

