/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.storageapi.storage;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.PatternSyntaxException;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.kayteam.nbtapi.NBTItem;
import org.kayteam.nbtapi.NBTType;
import org.kayteam.storageapi.storage.Storage;
import org.kayteam.xseries.XMaterial;

public class YML
extends Storage {
    private static final HashMap<String, String> globalReplacements = new HashMap();
    private final HashMap<String, String> replacements = new HashMap();
    private FileConfiguration defaultFileConfiguration;
    private FileConfiguration fileConfiguration;

    public YML(JavaPlugin javaPlugin, String directory, String fileName) {
        super(javaPlugin, directory, fileName);
    }

    public YML(JavaPlugin javaPlugin, String fileName) {
        super(javaPlugin, fileName);
    }

    public YML(String directory, String fileName) {
        super(directory, fileName);
    }

    public FileConfiguration getDefaultFileConfiguration() {
        return this.defaultFileConfiguration;
    }

    public FileConfiguration getFileConfiguration() {
        return this.fileConfiguration;
    }

    public void setFileConfiguration(FileConfiguration fileConfiguration) {
        this.fileConfiguration = fileConfiguration;
    }

    @Override
    public void register() {
        if (this.fileConfiguration == null) {
            this.reload();
        }
    }

    @Override
    public void reload() {
        Set keys;
        File directory = new File(this.getDirectory());
        if (!directory.exists() && !directory.mkdirs()) {
            Bukkit.getLogger().log(Level.SEVERE, "Error: Fail in directory creation.");
        }
        this.setFile(new File(this.getDirectory(), this.getFileName() + ".yml"));
        if (!this.getFile().exists()) {
            try {
                if (this.getFile().createNewFile() && this.getJavaPlugin() != null) {
                    InputStream inputStream;
                    String localDirectory = "";
                    if (!this.getDirectory().equals(this.getJavaPlugin().getDataFolder().getPath())) {
                        localDirectory = this.getDirectory().replaceAll(this.getJavaPlugin().getDataFolder().getPath(), "");
                        localDirectory = localDirectory.replaceAll(File.separator, "/");
                        localDirectory = localDirectory.replaceFirst("/", "");
                        localDirectory = localDirectory + "/";
                    }
                    if ((inputStream = this.getJavaPlugin().getResource(localDirectory + this.getFileName() + ".yml")) != null) {
                        this.getJavaPlugin().saveResource(localDirectory + this.getFileName() + ".yml", true);
                    }
                }
            }
            catch (IOException | IllegalArgumentException e) {
                Bukkit.getLogger().log(Level.SEVERE, "Error: Local file failed in load.");
            }
        }
        if (this.getJavaPlugin() != null) {
            this.loadDefaultFileConfiguration();
        }
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.getFile());
        if (this.contains("replacements.global") && this.fileConfiguration.isConfigurationSection("replacements.global")) {
            keys = this.fileConfiguration.getConfigurationSection("replacements.global").getKeys(false);
            for (String key : keys) {
                Storage.getGlobalReplacements().put(key, "%" + this.getString("replacements.global." + key) + "%");
            }
        }
        if (this.contains("replacements.local") && this.fileConfiguration.isConfigurationSection("replacements.local")) {
            keys = this.fileConfiguration.getConfigurationSection("replacements.local").getKeys(false);
            for (String key : keys) {
                this.getReplacements().put(key, "%" + this.getString("replacements.local." + key) + "%");
            }
        }
    }

    @Override
    public void save() {
        try {
            this.fileConfiguration.save(this.getFile());
        }
        catch (IOException e) {
            Bukkit.getLogger().log(Level.SEVERE, "Error: File do not saved.");
        }
    }

    @Override
    public boolean delete() {
        File file = new File(this.getDirectory(), this.getFileName() + ".yml");
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    @Override
    public void createBackup() {
        YML backup = new YML(this.getDirectory(), this.getFileName() + "-backup");
        backup.register();
        backup.setFileConfiguration(this.fileConfiguration);
        backup.save();
    }

    public List<YML> getYMLFiles(JavaPlugin javaPlugin, String directory) {
        return YML.getYMLFiles(javaPlugin.getDataFolder() + File.separator + directory);
    }

    public static List<YML> getYMLFiles(String directory) {
        File[] files;
        ArrayList<YML> simpleYMLList = new ArrayList<YML>();
        File dir = new File(directory);
        if (dir.exists() && (files = dir.listFiles((dir1, name) -> name.endsWith(".yml"))) != null) {
            for (File file : files) {
                simpleYMLList.add(new YML(directory, file.getName().replaceAll(".yml", "")));
            }
        }
        return simpleYMLList;
    }

    public void loadDefaultFileConfiguration() {
        try {
            if (this.getJavaPlugin() != null) {
                InputStream inputStream;
                String localDirectory = "";
                if (!this.getDirectory().equals(this.getJavaPlugin().getDataFolder().getPath())) {
                    localDirectory = this.getDirectory().replaceAll(this.getJavaPlugin().getDataFolder().getPath(), "");
                    localDirectory = localDirectory.replaceAll(File.separator, "/");
                    localDirectory = localDirectory.replaceFirst("/", "");
                    localDirectory = localDirectory + "/";
                }
                if ((inputStream = this.getJavaPlugin().getResource(localDirectory + this.getFileName() + ".yml")) != null) {
                    InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                    this.defaultFileConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Bukkit.getLogger().log(Level.SEVERE, "Error: Default file failed in the load.");
        }
    }

    @Override
    public boolean contains(String path) {
        return this.fileConfiguration.contains(path);
    }

    @Override
    public void set(String path, Object value) {
        this.fileConfiguration.set(path, value);
    }

    @Override
    public Object get(String path) {
        return this.get(path, null);
    }

    @Override
    public Object get(String path, Object def) {
        return this.get(path, def, true);
    }

    @Override
    public Object get(String path, Object def, boolean setDefaultIfNoExist) {
        if (!this.contains(path) && this.defaultFileConfiguration != null) {
            if (this.defaultFileConfiguration.contains(path)) {
                Object defaultFileValue = this.defaultFileConfiguration.get(path);
                this.set(path, defaultFileValue);
                this.save();
                return defaultFileValue;
            }
            if (setDefaultIfNoExist) {
                this.set(path, def);
            }
            this.save();
            return def;
        }
        return this.fileConfiguration.get(path);
    }

    @Override
    public boolean isBoolean(String path) {
        return this.fileConfiguration.isBoolean(path);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.getBoolean(path, def, true);
    }

    @Override
    public boolean getBoolean(String path, boolean def, boolean setDefaultIfNoExist) {
        if (!this.contains(path) && this.defaultFileConfiguration != null) {
            if (this.defaultFileConfiguration.contains(path)) {
                boolean defaultFileValue = this.defaultFileConfiguration.getBoolean(path);
                this.set(path, defaultFileValue);
                this.save();
                return defaultFileValue;
            }
            if (setDefaultIfNoExist) {
                this.set(path, def);
            }
            this.save();
            return def;
        }
        return this.fileConfiguration.getBoolean(path);
    }

    @Override
    public void setBoolean(String path, boolean value) {
        this.set(path, value);
    }

    @Override
    public boolean isInt(String path) {
        return this.fileConfiguration.isInt(path);
    }

    @Override
    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    @Override
    public int getInt(String path, int def) {
        return this.getInt(path, def, true);
    }

    @Override
    public int getInt(String path, int def, boolean setDefaultIfNoExist) {
        if (!this.contains(path) && this.defaultFileConfiguration != null) {
            if (this.defaultFileConfiguration.contains(path)) {
                if (setDefaultIfNoExist) {
                    this.set(path, this.defaultFileConfiguration.getInt(path));
                    this.save();
                }
                return this.defaultFileConfiguration.getInt(path);
            }
            if (setDefaultIfNoExist) {
                this.set(path, def);
                this.save();
            }
            return def;
        }
        return this.fileConfiguration.getInt(path);
    }

    @Override
    public void setInt(String path, int value) {
        this.set(path, value);
    }

    @Override
    public boolean isLong(String path) {
        return this.fileConfiguration.isLong(path);
    }

    @Override
    public long getLong(String path) {
        return this.getLong(path, 0L);
    }

    @Override
    public long getLong(String path, long def) {
        return this.getLong(path, def, true);
    }

    @Override
    public long getLong(String path, long def, boolean setDefaultIfNoExist) {
        if (!this.contains(path) && this.defaultFileConfiguration != null) {
            if (this.defaultFileConfiguration.contains(path)) {
                long defaultFileValue = this.defaultFileConfiguration.getLong(path);
                this.set(path, defaultFileValue);
                this.save();
                return defaultFileValue;
            }
            if (setDefaultIfNoExist) {
                this.set(path, def);
            }
            this.save();
            return def;
        }
        return this.fileConfiguration.getLong(path);
    }

    @Override
    public void setLong(String path, long value) {
        this.set(path, value);
    }

    @Override
    public boolean isDouble(String path) {
        return this.fileConfiguration.isDouble(path);
    }

    @Override
    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    @Override
    public double getDouble(String path, double def) {
        return this.getDouble(path, def, true);
    }

    @Override
    public double getDouble(String path, double def, boolean setDefaultIfNoExist) {
        if (!this.contains(path) && this.defaultFileConfiguration != null) {
            if (this.defaultFileConfiguration.contains(path)) {
                double defaultFileValue = this.defaultFileConfiguration.getDouble(path);
                this.set(path, defaultFileValue);
                this.save();
                return defaultFileValue;
            }
            if (setDefaultIfNoExist) {
                this.set(path, def);
            }
            this.save();
            return def;
        }
        return this.fileConfiguration.getDouble(path);
    }

    @Override
    public void setDouble(String path, double value) {
        this.set(path, value);
    }

    @Override
    public boolean isString(String path) {
        return this.fileConfiguration.isString(path);
    }

    @Override
    public String getString(String path) {
        return this.getString(path, new String[0][]);
    }

    public String getString(String path, String[][] replacements) {
        return this.getString(path, "", replacements);
    }

    @Override
    public String getString(String path, String def) {
        return this.getString(path, def, true);
    }

    public String getString(String path, String def, String[][] replacements) {
        return this.getString(path, def, false, replacements);
    }

    @Override
    public String getString(String path, String def, boolean setDefaultIfNoExist) {
        return this.getString(path, def, setDefaultIfNoExist, new String[0][]);
    }

    public String getString(String path, String def, boolean setDefaultIfNoExist, String[][] replacements) {
        if (!this.contains(path) && this.defaultFileConfiguration != null) {
            if (this.defaultFileConfiguration.contains(path)) {
                String defaultFileValue = this.defaultFileConfiguration.getString(path);
                this.set(path, defaultFileValue);
                this.save();
                return defaultFileValue;
            }
            if (setDefaultIfNoExist) {
                this.set(path, def);
            }
            this.save();
            return def;
        }
        String result = this.fileConfiguration.getString(path);
        for (String[] replacement : replacements) {
            String key = replacement[0];
            String value = replacement[1];
            result = result.replaceAll(key, value);
        }
        for (String key : YML.getGlobalReplacements().keySet()) {
            result = result.replaceAll(key, YML.getGlobalReplacements().get(key));
        }
        for (String key : this.getReplacements().keySet()) {
            result = result.replaceAll(key, this.getReplacements().get(key));
        }
        return result;
    }

    @Override
    public void setString(String path, String value) {
        this.set(path, value);
    }

    @Override
    public boolean isStringList(String path) {
        return this.fileConfiguration.isList(path);
    }

    @Override
    public List<String> getStringList(String path) {
        return this.getStringList(path, new String[0][]);
    }

    public List<String> getStringList(String path, String[][] replacements) {
        return this.getStringList(path, new ArrayList<String>(), replacements);
    }

    @Override
    public List<String> getStringList(String path, List<String> def) {
        return this.getStringList(path, def, true);
    }

    public List<String> getStringList(String path, List<String> def, String[][] replacements) {
        return this.getStringList(path, def, true, replacements);
    }

    @Override
    public List<String> getStringList(String path, List<String> def, boolean setDefaultIfNoExist) {
        return this.getStringList(path, def, setDefaultIfNoExist, new String[0][]);
    }

    public List<String> getStringList(String path, List<String> def, boolean setDefaultIfNoExist, String[][] replacements) {
        List<String> result = new ArrayList();
        if (!this.contains(path)) {
            if (this.defaultFileConfiguration != null) {
                if (this.defaultFileConfiguration.contains(path)) {
                    result = this.defaultFileConfiguration.getStringList(path);
                    this.set(path, result);
                    this.save();
                } else {
                    if (setDefaultIfNoExist) {
                        this.set(path, def);
                    }
                    this.save();
                    result = def;
                }
            }
        } else {
            result = this.fileConfiguration.getStringList(path);
        }
        for (int i = 0; i < result.size(); ++i) {
            String line = result.get(i);
            for (String[] replacement : replacements) {
                line = line.replaceAll(replacement[0], replacement[1]);
            }
            for (String key : YML.getGlobalReplacements().keySet()) {
                line = line.replaceAll(key, YML.getGlobalReplacements().get(key));
            }
            for (String key : this.getReplacements().keySet()) {
                line = line.replaceAll(key, YML.getGlobalReplacements().get(key));
            }
            result.set(i, line);
        }
        return result;
    }

    @Override
    public void setStringList(String path, List<String> value) {
        this.set(path, value);
    }

    @Override
    public boolean isLocation(String path) {
        String location;
        if (this.isString(path) && (location = this.getString(path)).contains(":")) {
            return location.split(":").length == 6 || location.split(":").length == 4;
        }
        return false;
    }

    @Override
    public Location getLocation(String path) {
        return this.getLocation(path, null);
    }

    @Override
    public Location getLocation(String path, Location def) {
        return this.getLocation(path, def, true);
    }

    @Override
    public Location getLocation(String path, Location def, boolean setDefaultIfNoExist) {
        double z;
        double y;
        double x;
        World world;
        String locationString = this.getString(path);
        Location location = null;
        if (locationString.split(":").length == 4) {
            try {
                world = Bukkit.getWorld((String)locationString.split(":")[0]);
                x = Double.parseDouble(locationString.split(":")[1]);
                y = Double.parseDouble(locationString.split(":")[2]);
                z = Double.parseDouble(locationString.split(":")[3]);
                location = new Location(world, x, y, z);
            }
            catch (NullPointerException | NumberFormatException | PatternSyntaxException e) {
                e.printStackTrace();
            }
        }
        if (locationString.split(":").length == 6) {
            try {
                world = Bukkit.getWorld((String)locationString.split(":")[0]);
                x = Double.parseDouble(locationString.split(":")[1]);
                y = Double.parseDouble(locationString.split(":")[2]);
                z = Double.parseDouble(locationString.split(":")[3]);
                float yaw = Float.parseFloat(locationString.split(":")[4]);
                float pitch = Float.parseFloat(locationString.split(":")[5]);
                location = new Location(world, x, y, z, yaw, pitch);
            }
            catch (NullPointerException | NumberFormatException | PatternSyntaxException e) {
                e.printStackTrace();
            }
        }
        return location;
    }

    @Override
    public void setLocation(String path, Location value) {
        String world = value.getWorld().getName();
        double x = value.getX();
        double y = value.getY();
        double z = value.getZ();
        float yaw = value.getYaw();
        float pitch = value.getPitch();
        String result = world + ":" + x + ":" + y + ":" + z + ":" + yaw + ":" + pitch;
        this.set(path, result);
    }

    @Override
    public boolean isItemStack(String path) {
        if (!this.fileConfiguration.isConfigurationSection(path)) {
            return false;
        }
        return this.contains(path + ".material");
    }

    public ItemStack getCustomSkull(String url) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        if (url.isEmpty()) {
            return head;
        }
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", url));
        try {
            Method mtd = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            mtd.setAccessible(true);
            mtd.invoke((Object)skullMeta, profile);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }

    @Override
    public ItemStack getItemStack(String path) {
        ItemStack result = null;
        if (!this.contains(path)) {
            if (this.defaultFileConfiguration.contains(path)) {
                short data;
                Material material;
                XMaterial xMaterial;
                int amount = this.defaultFileConfiguration.getInt(path + ".amount", 1);
                if (this.defaultFileConfiguration.getString(path + ".material").startsWith("basehead-")) {
                    xMaterial = XMaterial.matchXMaterial("PLAYER_HEAD").orElse(null);
                    material = xMaterial.parseMaterial();
                    data = -1;
                    if (this.defaultFileConfiguration.contains(path + ".data")) {
                        if (this.defaultFileConfiguration.isInt(path + ".data")) {
                            data = (short)this.defaultFileConfiguration.getInt(path + ".data");
                        }
                    } else {
                        data = xMaterial.getData();
                    }
                    if (material != null) {
                        result = data != -1 ? new ItemStack(material, amount, data) : new ItemStack(material, amount);
                    }
                    String value = this.defaultFileConfiguration.getString(path + ".material").replaceFirst("basehead-", "");
                    SkullMeta skullMeta = (SkullMeta)result.getItemMeta();
                    GameProfile profile = new GameProfile(UUID.randomUUID(), null);
                    profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
                    try {
                        Method mtd = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                        mtd.setAccessible(true);
                        mtd.invoke((Object)skullMeta, profile);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                    result.setItemMeta((ItemMeta)skullMeta);
                } else if (this.defaultFileConfiguration.getString(path + ".material").startsWith("playerhead-")) {
                    xMaterial = XMaterial.matchXMaterial("PLAYER_HEAD").orElse(null);
                    assert (xMaterial != null);
                    material = xMaterial.parseMaterial();
                    data = -1;
                    if (this.defaultFileConfiguration.contains(path + ".data")) {
                        if (this.defaultFileConfiguration.isInt(path + ".data")) {
                            data = (short)this.defaultFileConfiguration.getInt(path + ".data");
                        }
                    } else {
                        data = xMaterial.getData();
                    }
                    if (material != null) {
                        result = data != -1 ? new ItemStack(material, amount, data) : new ItemStack(material, amount);
                    }
                    SkullMeta skullMeta = (SkullMeta)result.getItemMeta();
                    skullMeta.setOwner(this.defaultFileConfiguration.getString(path + ".material").replaceFirst("playerhead-", ""));
                    result.setItemMeta((ItemMeta)skullMeta);
                } else {
                    xMaterial = XMaterial.matchXMaterial(this.defaultFileConfiguration.getString(path + ".material")).orElse(null);
                    assert (xMaterial != null);
                    material = xMaterial.parseMaterial();
                    data = -1;
                    if (this.defaultFileConfiguration.contains(path + ".data")) {
                        if (this.defaultFileConfiguration.isInt(path + ".data")) {
                            data = (short)this.defaultFileConfiguration.getInt(path + ".data");
                        }
                    } else {
                        data = xMaterial.getData();
                    }
                    if (material != null) {
                        result = data != -1 ? new ItemStack(material, amount, data) : new ItemStack(material, amount);
                    }
                }
                if (result != null) {
                    ItemMeta itemMeta = result.getItemMeta();
                    if (itemMeta != null) {
                        if (this.defaultFileConfiguration.contains(path + ".name") && this.defaultFileConfiguration.isString(path + ".name")) {
                            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.defaultFileConfiguration.getString(path + ".name")));
                        }
                        if (this.defaultFileConfiguration.contains(path + ".lore") && this.defaultFileConfiguration.isList(path + ".lore")) {
                            List lore = this.defaultFileConfiguration.getStringList(path + ".lore");
                            lore.replaceAll(textToTranslate -> ChatColor.translateAlternateColorCodes((char)'&', (String)textToTranslate));
                            itemMeta.setLore(lore);
                        }
                        if (this.defaultFileConfiguration.contains(path + ".flags") && this.defaultFileConfiguration.isList(path + ".flags")) {
                            List flags = this.defaultFileConfiguration.getStringList(path + ".flags");
                            for (String flag : flags) {
                                ItemFlag itemFlag = ItemFlag.valueOf((String)flag);
                                itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
                            }
                        }
                    }
                    result.setItemMeta(itemMeta);
                    if (this.defaultFileConfiguration.contains(path + ".enchantments")) {
                        Set names = Objects.requireNonNull(this.defaultFileConfiguration.getConfigurationSection(path + ".enchantments")).getValues(false).keySet();
                        for (String name : names) {
                            Enchantment enchantment = Enchantment.getByName((String)name);
                            if (enchantment == null) continue;
                            result.addUnsafeEnchantment(enchantment, this.defaultFileConfiguration.getInt(path + ".enchantments." + name));
                        }
                    }
                    if (this.defaultFileConfiguration.contains(path + ".durability") && this.defaultFileConfiguration.isInt(path + ".durability")) {
                        result.setDurability((short)this.defaultFileConfiguration.getInt(path + ".durability"));
                    }
                    if (this.defaultFileConfiguration.contains(path + ".nbt")) {
                        NBTItem nbtItem = new NBTItem(result);
                        for (String key : Objects.requireNonNull(this.defaultFileConfiguration.getConfigurationSection(path + ".nbt")).getKeys(false)) {
                            try {
                                if (this.defaultFileConfiguration.isString(path + ".nbt." + key)) {
                                    nbtItem.setString(key, this.defaultFileConfiguration.getString(path + ".nbt." + key));
                                    continue;
                                }
                                if (this.defaultFileConfiguration.isInt(path + ".nbt." + key)) {
                                    nbtItem.setInteger(key, this.defaultFileConfiguration.getInt(path + ".nbt." + key));
                                    continue;
                                }
                                Bukkit.getLogger().log(Level.SEVERE, "An error has occurred trying load NBT: " + key + ". Please enter a valid type: STRING/INTEGER.");
                            }
                            catch (Exception e) {
                                Bukkit.getLogger().log(Level.SEVERE, "An error has occurred trying load NBT: " + key);
                            }
                        }
                        result = nbtItem.getItem();
                    }
                    if ((result.getType().equals((Object)Material.valueOf((String)"LEATHER_HELMET")) || result.getType().equals((Object)Material.valueOf((String)"LEATHER_CHESTPLATE")) || result.getType().equals((Object)Material.valueOf((String)"LEATHER_LEGGINGS")) || result.getType().equals((Object)Material.valueOf((String)"LEATHER_BOOTS"))) && this.contains(path + ".color") && this.isString(path + ".color")) {
                        String colorString = this.defaultFileConfiguration.getString(path + ".color").replaceAll("#", "0x");
                        int color = Integer.parseInt(colorString);
                        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)result.getItemMeta();
                        leatherArmorMeta.setColor(Color.fromRGB((int)color));
                        result.setItemMeta((ItemMeta)leatherArmorMeta);
                    }
                }
            }
        } else {
            short data;
            Material material;
            XMaterial xMaterial;
            int amount = this.getInt(path + ".amount", 1, false);
            if (this.getString(path + ".material").startsWith("basehead-")) {
                xMaterial = XMaterial.matchXMaterial("PLAYER_HEAD").orElse(null);
                material = xMaterial.parseMaterial();
                data = -1;
                if (this.contains(path + ".data")) {
                    if (this.isInt(path + ".data")) {
                        data = (short)this.getInt(path + ".data");
                    }
                } else {
                    data = xMaterial.getData();
                }
                if (material != null) {
                    result = data != -1 ? new ItemStack(material, amount, data) : new ItemStack(material, amount);
                }
                String value = this.getString(path + ".material").replaceFirst("basehead-", "");
                SkullMeta skullMeta = (SkullMeta)result.getItemMeta();
                GameProfile profile = new GameProfile(UUID.randomUUID(), null);
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
                try {
                    Method mtd = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                    mtd.setAccessible(true);
                    mtd.invoke((Object)skullMeta, profile);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    try {
                        Field profileField = skullMeta.getClass().getDeclaredField("profile");
                        profileField.setAccessible(true);
                        profileField.set(skullMeta, profile);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
                result.setItemMeta((ItemMeta)skullMeta);
            } else if (this.getString(path + ".material").startsWith("playerhead-")) {
                xMaterial = XMaterial.matchXMaterial("PLAYER_HEAD").orElse(null);
                assert (xMaterial != null);
                material = xMaterial.parseMaterial();
                data = -1;
                if (this.contains(path + ".data")) {
                    if (this.isInt(path + ".data")) {
                        data = (short)this.getInt(path + ".data");
                    }
                } else {
                    data = xMaterial.getData();
                }
                if (material != null) {
                    result = data != -1 ? new ItemStack(material, amount, data) : new ItemStack(material, amount);
                }
                SkullMeta skullMeta = (SkullMeta)result.getItemMeta();
                skullMeta.setOwner(this.getString(path + ".material").replaceFirst("playerhead-", ""));
                result.setItemMeta((ItemMeta)skullMeta);
            } else {
                xMaterial = XMaterial.matchXMaterial(this.getString(path + ".material")).orElse(null);
                assert (xMaterial != null);
                material = xMaterial.parseMaterial();
                data = -1;
                if (this.contains(path + ".data")) {
                    if (this.isInt(path + ".data")) {
                        data = (short)this.getInt(path + ".data");
                    }
                } else {
                    data = xMaterial.getData();
                }
                if (material != null) {
                    result = data != -1 ? new ItemStack(material, amount, data) : new ItemStack(material, amount);
                }
            }
            if (result != null) {
                ItemMeta itemMeta = result.getItemMeta();
                if (itemMeta != null) {
                    if (this.contains(path + ".name") && this.isString(path + ".name")) {
                        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getString(path + ".name")));
                    }
                    if (this.contains(path + ".lore") && this.isStringList(path + ".lore")) {
                        List<String> lore = this.getStringList(path + ".lore");
                        lore.replaceAll(textToTranslate -> ChatColor.translateAlternateColorCodes((char)'&', (String)textToTranslate));
                        itemMeta.setLore(lore);
                    }
                    if (this.contains(path + ".flags") && this.isStringList(path + ".flags")) {
                        List<String> flags = this.getStringList(path + ".flags");
                        for (String flag : flags) {
                            ItemFlag itemFlag = ItemFlag.valueOf((String)flag);
                            itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
                        }
                    }
                }
                result.setItemMeta(itemMeta);
                if (this.contains(path + ".enchantments")) {
                    Set names = Objects.requireNonNull(this.fileConfiguration.getConfigurationSection(path + ".enchantments")).getValues(false).keySet();
                    for (String name : names) {
                        Enchantment enchantment = Enchantment.getByName((String)name);
                        if (enchantment == null) continue;
                        result.addUnsafeEnchantment(enchantment, this.getInt(path + ".enchantments." + name));
                    }
                }
                if (this.contains(path + ".durability") && this.isInt(path + ".durability")) {
                    result.setDurability((short)this.getInt(path + ".durability"));
                }
                if (this.contains(path + ".nbt")) {
                    NBTItem nbtItem = new NBTItem(result);
                    for (String key : Objects.requireNonNull(this.fileConfiguration.getConfigurationSection(path + ".nbt")).getKeys(false)) {
                        try {
                            if (this.isString(path + ".nbt." + key)) {
                                nbtItem.setString(key, this.getString(path + ".nbt." + key));
                                continue;
                            }
                            if (this.isInt(path + ".nbt." + key)) {
                                nbtItem.setInteger(key, this.getInt(path + ".nbt." + key));
                                continue;
                            }
                            Bukkit.getLogger().log(Level.SEVERE, "An error has occurred trying load NBT: " + key + ". Please enter a valid type: STRING/INTEGER.");
                        }
                        catch (Exception e) {
                            Bukkit.getLogger().log(Level.SEVERE, "An error has occurred trying load NBT: " + key);
                        }
                    }
                    result = nbtItem.getItem();
                }
                if ((result.getType().equals((Object)Material.valueOf((String)"LEATHER_HELMET")) || result.getType().equals((Object)Material.valueOf((String)"LEATHER_CHESTPLATE")) || result.getType().equals((Object)Material.valueOf((String)"LEATHER_LEGGINGS")) || result.getType().equals((Object)Material.valueOf((String)"LEATHER_BOOTS"))) && this.contains(path + ".color") && this.isString(path + ".color")) {
                    String colorString = this.getString(path + ".color").replaceAll("#", "0x");
                    int color = Integer.parseInt(colorString);
                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)result.getItemMeta();
                    leatherArmorMeta.setColor(Color.fromRGB((int)color));
                    result.setItemMeta((ItemMeta)leatherArmorMeta);
                }
            }
        }
        return result;
    }

    @Override
    public ItemStack getItemStack(String path, ItemStack def) {
        ItemStack result = this.getItemStack(path, def, true);
        if (result == null) {
            return def;
        }
        return result;
    }

    @Override
    public ItemStack getItemStack(String path, ItemStack def, boolean setDefaultIfNoExist) {
        ItemStack result = this.getItemStack(path);
        if (result == null) {
            this.setItemStack(path, def);
            return def;
        }
        return result;
    }

    @Override
    public void setItemStack(String path, ItemStack value) {
        this.set(path + ".material", value.getType().toString());
        this.set(path + ".amount", value.getAmount());
        ItemMeta itemMeta = value.getItemMeta();
        if (itemMeta != null) {
            if (itemMeta.hasDisplayName()) {
                this.set(path + ".name", itemMeta.getDisplayName());
            }
            if (itemMeta.hasLore()) {
                this.set(path + ".lore", itemMeta.getLore());
            }
            if (!itemMeta.getItemFlags().isEmpty()) {
                ArrayList flags = new ArrayList();
                for (ItemFlag flag : itemMeta.getItemFlags()) {
                    flags.add(flag.toString());
                }
                this.set(path + ".flags", flags);
            }
            if (!value.getEnchantments().isEmpty()) {
                for (Object enchantment : value.getEnchantments().keySet()) {
                    this.set(path + ".enchantments." + enchantment.getName(), value.getEnchantments().get(enchantment));
                }
            }
            if (!Objects.equals(Objects.requireNonNull(value.getData()).toString(), "0")) {
                this.set(path + ".data", value.getData().getData());
            }
            if (value.getType().getMaxDurability() != value.getDurability()) {
                this.set(path + ".durability", value.getDurability());
            }
            NBTItem nbtItem = new NBTItem(value);
            for (String key : nbtItem.getKeys()) {
                if (nbtItem.getType(key).equals((Object)NBTType.NBTTagString)) {
                    this.set(path + ".nbt." + key, nbtItem.getString(key));
                    continue;
                }
                if (!nbtItem.getType(key).equals((Object)NBTType.NBTTagInt)) continue;
                this.set(path + ".nbt." + key, nbtItem.getInteger(key));
            }
            if (value.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_HELMET").orElse(null))).parseMaterial()) || value.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_CHESTPLATE").orElse(null))).parseMaterial()) || value.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_LEGGINGS").orElse(null))).parseMaterial()) || value.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_BOOTS").orElse(null))).parseMaterial())) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)value.getItemMeta();
                int color = leatherArmorMeta.getColor().asRGB();
                String colorString = String.valueOf(color);
                this.set(path + ".color", colorString.replaceAll("0x", "#"));
            }
            if (value.getType().toString().equals("PLAYER_HEAD") || value.getType().toString().equals("LEGACY_SKULL_ITEM")) {
                SkullMeta meta = (SkullMeta)value.getItemMeta();
                GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                this.set(path + ".material", "basehead-" + profile.getProperties().get((Object)"textures"));
            }
        }
    }

    public void sendMessage(CommandSender commandSender, String path) {
        this.sendMessage(commandSender, path, new String[0][]);
    }

    /*
     * WARNING - void declaration
     */
    public void sendMessage(CommandSender commandSender, String path, String[][] replacements) {
        List<Object> messages = new ArrayList();
        if (this.isStringList(path)) {
            messages = this.getStringList(path, replacements);
        } else if (this.isString(path)) {
            messages.add(this.getString(path, replacements));
        }
        for (String string : messages) {
            void var6_13;
            void var6_10;
            for (String text : this.replacements.keySet()) {
                void var6_8;
                String string2 = var6_8.replaceAll("%" + text + "%", this.replacements.get(text));
            }
            for (String text : globalReplacements.keySet()) {
                String string3 = var6_10.replaceAll("%" + text + "%", globalReplacements.get(text));
            }
            if (commandSender instanceof Player && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                String string4 = PlaceholderAPI.setPlaceholders((Player)((Player)commandSender), (String)var6_10);
            }
            String string5 = ChatColor.translateAlternateColorCodes((char)'&', (String)var6_13);
            commandSender.sendMessage(string5);
        }
    }

    public static void sendSimpleMessage(CommandSender commandSender, Object message) {
        YML.sendSimpleMessage(commandSender, message, new String[0][]);
    }

    public static void sendSimpleMessage(CommandSender commandSender, Object message, String[][] replacements) {
        List<String> messages = new ArrayList();
        if (message.getClass().getSimpleName().equals("ArrayList")) {
            messages = (List)message;
        } else if (message.getClass().getSimpleName().equals("String")) {
            messages.add((String)message);
        }
        for (String m : messages) {
            for (String[] replacement : replacements) {
                m = m.replaceAll(replacement[0], replacement[1]);
            }
            for (String text : globalReplacements.keySet()) {
                m = m.replaceAll("%" + text + "%", globalReplacements.get(text));
            }
            if (commandSender instanceof Player && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                m = PlaceholderAPI.setPlaceholders((Player)((Player)commandSender), (String)m);
            }
            m = ChatColor.translateAlternateColorCodes((char)'&', (String)m);
            commandSender.sendMessage(m);
        }
    }
}

