/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.storageapi.storage;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.kayteam.nbtapi.NBTItem;
import org.kayteam.nbtapi.NBTType;
import org.kayteam.xseries.XMaterial;

public class Yaml {
    private static final HashMap<String, String> globalReplacements = new HashMap();
    private final HashMap<String, String> replacements = new HashMap();
    private JavaPlugin javaPlugin = null;
    private final String directory;
    private final String name;
    private File file;
    private FileConfiguration fileConfiguration;

    public Yaml(JavaPlugin javaPlugin, String directory, String name) {
        this.javaPlugin = javaPlugin;
        this.directory = javaPlugin.getDataFolder().getPath() + File.separator + directory;
        this.name = name;
    }

    public Yaml(JavaPlugin javaPlugin, String name) {
        this.javaPlugin = javaPlugin;
        this.directory = javaPlugin.getDataFolder().getPath();
        this.name = name;
    }

    public Yaml(String directory, String name) {
        this.directory = directory;
        this.name = name;
    }

    public JavaPlugin getJavaPlugin() {
        return this.javaPlugin;
    }

    public String getName() {
        return this.name;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void registerYamlFile() {
        if (this.fileConfiguration == null) {
            this.reloadYamlFile();
        }
    }

    public void reloadYamlFile() {
        File dir = new File(this.directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.file = new File(this.directory, this.name + ".yml");
        if (!this.file.exists()) {
            try {
                if (this.file.createNewFile() && this.javaPlugin != null) {
                    String localDirectory = "";
                    if (!this.directory.equals(this.javaPlugin.getDataFolder().getPath())) {
                        localDirectory = this.directory.replaceAll(this.javaPlugin.getDataFolder().getPath(), "");
                        localDirectory = localDirectory.replaceAll(File.separator, "/");
                        localDirectory = localDirectory.replaceFirst("/", "");
                        localDirectory = localDirectory + "/";
                    }
                    if (this.javaPlugin.getResource(localDirectory + this.name + ".yml") != null) {
                        this.javaPlugin.saveResource(localDirectory + this.name + ".yml", true);
                    }
                }
            }
            catch (IOException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        if (this.contains("replacements.global") && this.fileConfiguration.isConfigurationSection("replacements.global")) {
            for (String key : this.getConfigurationSection("replacements.global").getKeys(false)) {
                globalReplacements.put(key, this.getString("replacements.global." + key));
            }
        }
        if (this.contains("replacements.local") && this.fileConfiguration.isConfigurationSection("replacements.local")) {
            for (String key : this.getConfigurationSection("replacements.local").getKeys(false)) {
                this.replacements.put(key, this.getString("replacements.local." + key));
            }
        }
    }

    public void saveYamlFile() {
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            this.javaPlugin.getLogger().log(Level.SEVERE, "No se pudo guardar el archivo.");
        }
    }

    public FileConfiguration getFileConfiguration() {
        if (this.fileConfiguration == null) {
            this.reloadYamlFile();
        }
        return this.fileConfiguration;
    }

    public boolean deleteFile() {
        File file = new File(this.directory, this.name + ".yml");
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public boolean existFile() {
        return new File(this.directory, this.name + ".yml").exists();
    }

    public void generateBackup() {
        Yaml backup = new Yaml(this.directory, this.name + "-backup");
        backup.registerYamlFile();
        backup.saveWithOtherFileConfiguration(this.fileConfiguration);
    }

    public void saveWithOtherFileConfiguration(FileConfiguration fileConfiguration) {
        this.fileConfiguration = fileConfiguration;
        this.saveYamlFile();
    }

    public List<Yaml> getYamlFiles(JavaPlugin javaPlugin, String directory) {
        return Yaml.getYamlFiles(javaPlugin.getDataFolder() + File.separator + directory);
    }

    public static List<Yaml> getYamlFiles(String directory) {
        File[] files;
        ArrayList<Yaml> simpleYamlList = new ArrayList<Yaml>();
        File dir = new File(directory);
        if (dir.exists() && (files = dir.listFiles((dir1, name) -> name.endsWith(".yml"))) != null) {
            for (File file : files) {
                simpleYamlList.add(new Yaml(directory, file.getName().replaceAll(".yml", "")));
            }
        }
        return simpleYamlList;
    }

    public boolean isConfigurationSection(String path) {
        return this.fileConfiguration.isConfigurationSection(path);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        if (this.fileConfiguration.contains(path) && this.isConfigurationSection(path)) {
            return this.fileConfiguration.getConfigurationSection(path);
        }
        return null;
    }

    public ConfigurationSection getConfigurationSection(String path, ConfigurationSection def) {
        if (this.fileConfiguration.contains(path) && this.isConfigurationSection(path)) {
            return this.fileConfiguration.getConfigurationSection(path);
        }
        return def;
    }

    public boolean contains(String path) {
        return this.fileConfiguration.contains(path);
    }

    public void set(String path, Object value) {
        this.fileConfiguration.set(path, value);
    }

    public Object get(String path) {
        if (this.fileConfiguration.contains(path)) {
            return this.fileConfiguration.get(path);
        }
        return null;
    }

    public Object get(String path, Object def) {
        if (this.fileConfiguration.contains(path)) {
            return this.fileConfiguration.get(path);
        }
        return def;
    }

    public boolean isBoolean(String path) {
        return this.fileConfiguration.isBoolean(path);
    }

    public boolean getBoolean(String path) {
        if (this.contains(path) && this.isBoolean(path)) {
            return this.fileConfiguration.getBoolean(path);
        }
        return false;
    }

    public boolean getBoolean(String path, boolean def) {
        if (this.contains(path) && this.isBoolean(path)) {
            return this.fileConfiguration.getBoolean(path);
        }
        return def;
    }

    public boolean isInt(String path) {
        return this.fileConfiguration.isInt(path);
    }

    public int getInt(String path) {
        if (this.contains(path) && this.isInt(path)) {
            return this.fileConfiguration.getInt(path);
        }
        return -1;
    }

    public int getInt(String path, int def) {
        if (this.contains(path) && this.isInt(path)) {
            return this.fileConfiguration.getInt(path);
        }
        return def;
    }

    public boolean isLong(String path) {
        return this.fileConfiguration.isLong(path);
    }

    public long getLong(String path) {
        if (this.contains(path) && this.isLong(path)) {
            return this.fileConfiguration.getLong(path);
        }
        return -1L;
    }

    public long getLong(String path, long def) {
        if (this.contains(path) && this.isLong(path)) {
            return this.fileConfiguration.getLong(path);
        }
        return def;
    }

    public boolean isDouble(String path) {
        return this.fileConfiguration.isDouble(path);
    }

    public double getDouble(String path) {
        if (this.contains(path) && this.isDouble(path)) {
            return this.fileConfiguration.getDouble(path);
        }
        return -1.0;
    }

    public double getDouble(String path, double def) {
        if (this.contains(path) && this.isDouble(path)) {
            return this.fileConfiguration.getDouble(path);
        }
        return def;
    }

    public boolean isString(String path) {
        return this.fileConfiguration.isString(path);
    }

    public String getString(String path) {
        if (this.contains(path) && this.isString(path)) {
            return this.fileConfiguration.getString(path);
        }
        return "";
    }

    public String getString(String path, String[][] replacements) {
        return this.getString(path, "", replacements);
    }

    public String getString(String path, String def) {
        if (this.contains(path) && this.isString(path)) {
            return this.fileConfiguration.getString(path);
        }
        return def;
    }

    public String getString(String path, String def, String[][] replacements) {
        String string = this.getString(path, def);
        for (String[] replacement : replacements) {
            string = string.replaceAll(replacement[0], replacement[1]);
        }
        return string;
    }

    public boolean isStringList(String path) {
        if (this.contains(path)) {
            return this.fileConfiguration.getList(path).get(0).getClass().getSimpleName().equals("String");
        }
        return false;
    }

    public List<String> getStringList(String path) {
        if (this.contains(path) && this.isList(path)) {
            return this.fileConfiguration.getStringList(path);
        }
        return new ArrayList<String>();
    }

    public List<String> getStringList(String path, String[][] replacements) {
        return this.getStringList(path, new ArrayList<String>(), replacements);
    }

    public List<String> getStringList(String path, List<String> def) {
        if (this.contains(path) && this.isList(path)) {
            return this.fileConfiguration.getStringList(path);
        }
        return def;
    }

    public List<String> getStringList(String path, List<String> def, String[][] replacements) {
        List<String> strings = this.getStringList(path, def);
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            for (String[] replacement : replacements) {
                string = string.replaceAll(replacement[0], replacement[1]);
            }
            strings.set(i, string);
        }
        return strings;
    }

    public boolean isList(String path) {
        return this.fileConfiguration.isList(path);
    }

    public List<?> getList(String path) {
        if (this.contains(path) && this.isList(path)) {
            return this.fileConfiguration.getList(path);
        }
        return new ArrayList();
    }

    public List<?> getList(String path, List<Object> def) {
        if (this.contains(path) && this.isList(path)) {
            return this.fileConfiguration.getList(path);
        }
        return def;
    }

    public boolean isLocation(String path) {
        boolean result = false;
        if (this.contains(path + ".world") && this.isString(path + ".world") && this.contains(path + ".x") && this.isDouble(path + ".x") && this.contains(path + ".y") && this.isDouble(path + ".y") && this.contains(path + ".z") && this.isDouble(path + ".z")) {
            result = true;
        }
        return result;
    }

    public Location getLocation(String path) {
        World world = null;
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (this.contains(path + ".world") && this.isString(path + ".world") && (world = this.javaPlugin.getServer().getWorld(this.getString(path + ".world"))) == null) {
            return null;
        }
        if (!this.contains(path + ".x") || !this.isDouble(path + ".x")) {
            return null;
        }
        double x = this.getDouble(path + ".x");
        if (!this.contains(path + ".y") || !this.isDouble(path + ".y")) {
            return null;
        }
        double y = this.getDouble(path + ".y");
        if (!this.contains(path + ".z") || !this.isDouble(path + ".z")) {
            return null;
        }
        double z = this.getDouble(path + ".z");
        if (this.contains(path + ".yaw") && this.isDouble(path + ".yaw")) {
            yaw = (long)this.getDouble(path + ".yaw");
        }
        if (this.contains(path + ".pitch") && this.isDouble(path + ".pitch")) {
            pitch = (long)this.getDouble(path + ".pitch");
        }
        return new Location(world, x, y, z, yaw, pitch);
    }

    public void setLocation(String path, Location location) {
        this.set(path + ".world", Objects.requireNonNull(location.getWorld()).getName());
        this.set(path + ".x", location.getX());
        this.set(path + ".y", location.getY());
        this.set(path + ".z", location.getZ());
        this.set(path + ".yaw", Float.valueOf(location.getYaw()));
        this.set(path + ".pitch", Float.valueOf(location.getPitch()));
    }

    public void setLocation(String path, Location location, boolean yawAndPitch) {
        this.set(path + ".world", Objects.requireNonNull(location.getWorld()).getName());
        this.set(path + ".x", location.getX());
        this.set(path + ".y", location.getY());
        this.set(path + ".z", location.getZ());
        if (yawAndPitch) {
            this.set(path + ".yaw", Float.valueOf(location.getYaw()));
            this.set(path + ".pitch", Float.valueOf(location.getPitch()));
        }
    }

    public ItemStack getItemStack(String path) {
        return this.getItemStack(path, new String[0][]);
    }

    public ItemStack getItemStack(String path, String[][] replacements) {
        XMaterial xMaterial = XMaterial.matchXMaterial(this.getString(path + ".material")).orElse(null);
        assert (xMaterial != null);
        Material material = xMaterial.parseMaterial();
        int amount = this.getInt(path + ".amount", 1);
        short data = -1;
        if (this.contains(path + ".data")) {
            if (this.isInt(path + ".data")) {
                data = (short)this.getInt(path + ".data");
            }
        } else {
            data = xMaterial.getData();
        }
        if (material != null) {
            ItemStack itemStack = data != -1 ? new ItemStack(material, amount, data) : new ItemStack(material, amount);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta != null) {
                if (this.contains(path + ".name") && this.isString(path + ".name")) {
                    itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getString(path + ".name")));
                }
                if (this.contains(path + ".lore") && this.isList(path + ".lore")) {
                    List<String> lore = this.getStringList(path + ".lore");
                    for (int i = 0; i < lore.size(); ++i) {
                        lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)lore.get(i)));
                    }
                    itemMeta.setLore(lore);
                }
                if (this.contains(path + ".flags") && this.isList(path + ".flags")) {
                    List<String> flags = this.getStringList(path + ".flags");
                    for (String flag : flags) {
                        ItemFlag itemFlag = ItemFlag.valueOf((String)flag);
                        itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
                    }
                }
            }
            itemStack.setItemMeta(itemMeta);
            if (this.contains(path + ".enchantments")) {
                Set names = Objects.requireNonNull(this.getConfigurationSection(path + ".enchantments")).getValues(false).keySet();
                for (String name : names) {
                    Enchantment enchantment = Enchantment.getByName((String)name);
                    if (enchantment == null) continue;
                    itemStack.addUnsafeEnchantment(enchantment, this.getInt(path + ".enchantments." + name));
                }
            }
            if (this.contains(path + ".durability") && this.isInt(path + ".durability")) {
                itemStack.setDurability((short)this.getInt(path + ".durability"));
            }
            if (this.contains(path + ".nbt")) {
                NBTItem nbtItem = new NBTItem(itemStack);
                for (String key : Objects.requireNonNull(this.getConfigurationSection(path + ".nbt")).getKeys(false)) {
                    try {
                        if (this.isString(path + ".nbt." + key)) {
                            nbtItem.setString(key, this.getString(path + ".nbt." + key));
                            continue;
                        }
                        if (this.isInt(path + ".nbt." + key)) {
                            nbtItem.setInteger(key, this.getInt(path + ".nbt." + key));
                            continue;
                        }
                        this.javaPlugin.getLogger().log(Level.SEVERE, "An error has occurred trying load NBT: " + key + ". Please enter a valid type: STRING/INTEGER.");
                    }
                    catch (Exception e) {
                        this.javaPlugin.getLogger().log(Level.SEVERE, "An error has occurred trying load NBT: " + key);
                    }
                }
                itemStack = nbtItem.getItem();
            }
            if ((xMaterial.parseMaterial().equals((Object)((XMaterial)XMaterial.matchXMaterial("LEATHER_HELMET").orElse(null)).parseMaterial()) || xMaterial.parseMaterial().equals((Object)((XMaterial)XMaterial.matchXMaterial("LEATHER_CHESTPLATE").orElse(null)).parseMaterial()) || xMaterial.parseMaterial().equals((Object)((XMaterial)XMaterial.matchXMaterial("LEATHER_LEGGINGS").orElse(null)).parseMaterial()) || xMaterial.parseMaterial().equals((Object)((XMaterial)XMaterial.matchXMaterial("LEATHER_BOOTS").orElse(null)).parseMaterial())) && this.contains(path + ".color") && this.isString(path + ".color")) {
                String colorString = this.getString(path + ".color").replaceAll("#", "0x");
                int color = Integer.parseInt(colorString);
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
                leatherArmorMeta.setColor(Color.fromRGB((int)color));
                itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
            }
            if (xMaterial.parseMaterial().equals((Object)((XMaterial)XMaterial.matchXMaterial("PLAYER_HEAD").orElse(null)).parseMaterial())) {
                if (this.contains(path + ".base64-texture")) {
                    String value = this.getString(path + ".base64-texture");
                    SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
                    GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                    profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
                    try {
                        Field profileField = meta.getClass().getDeclaredField("profile");
                        profileField.setAccessible(true);
                        profileField.set(meta, profile);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        e.printStackTrace();
                    }
                    itemStack.setItemMeta((ItemMeta)meta);
                }
                if (this.contains(path + ".head-owner") && this.isString(path + ".head-owner")) {
                    SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                    assert (skullMeta != null);
                    skullMeta.setOwner(this.getString(path + ".head-owner"));
                    itemStack.setItemMeta((ItemMeta)skullMeta);
                }
            }
            return Yaml.replace(itemStack, replacements);
        }
        ItemStack error = new ItemStack(Material.DIRT);
        ItemMeta errorMeta = error.getItemMeta();
        if (errorMeta != null) {
            errorMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cERROR"));
        }
        error.setItemMeta(errorMeta);
        return error;
    }

    public ItemStack getCustomTextureHead(String value) {
        ItemStack head;
        try {
            head = new ItemStack(Material.PLAYER_HEAD);
        }
        catch (Throwable var2) {
            head = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        }
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        Field profileField = null;
        try {
            profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(meta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public void setItemStack(String path, ItemStack item) {
        block15: {
            this.set(path + ".material", item.getType().toString());
            this.set(path + ".amount", item.getAmount());
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta != null) {
                if (itemMeta.hasDisplayName()) {
                    this.set(path + ".name", itemMeta.getDisplayName());
                }
                if (itemMeta.hasLore()) {
                    this.set(path + ".lore", itemMeta.getLore());
                }
                if (!itemMeta.getItemFlags().isEmpty()) {
                    ArrayList flags = new ArrayList();
                    for (ItemFlag flag : itemMeta.getItemFlags()) {
                        flags.add(flag.toString());
                    }
                    this.set(path + ".flags", flags);
                }
                if (!item.getEnchantments().isEmpty()) {
                    for (Object enchantment : item.getEnchantments().keySet()) {
                        this.set(path + ".enchantments." + enchantment.getName(), item.getEnchantments().get(enchantment));
                    }
                }
                if (!Objects.equals(Objects.requireNonNull(item.getData()).toString(), "0")) {
                    this.set(path + ".data", item.getData().getData());
                }
                if (item.getType().getMaxDurability() != item.getDurability()) {
                    this.set(path + ".durability", item.getDurability());
                }
                NBTItem nbtItem = new NBTItem(item);
                for (String key : nbtItem.getKeys()) {
                    if (nbtItem.getType(key).equals((Object)NBTType.NBTTagString)) {
                        this.set(path + ".nbt." + key, nbtItem.getString(key));
                        continue;
                    }
                    if (!nbtItem.getType(key).equals((Object)NBTType.NBTTagInt)) continue;
                    this.set(path + ".nbt." + key, nbtItem.getInteger(key));
                }
                if (item.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_HELMET").orElse(null))).parseMaterial()) || item.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_CHESTPLATE").orElse(null))).parseMaterial()) || item.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_LEGGINGS").orElse(null))).parseMaterial()) || item.getType().equals((Object)((XMaterial)Objects.requireNonNull(XMaterial.matchXMaterial("LEATHER_BOOTS").orElse(null))).parseMaterial())) {
                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)item.getItemMeta();
                    int color = leatherArmorMeta.getColor().asRGB();
                    String colorString = String.valueOf(color);
                    this.set(path + ".color", colorString.replaceAll("0x", "#"));
                }
                try {
                    SkullMeta skullMeta;
                    if (item.getType().toString().equals("PLAYER_HEAD") && (skullMeta = (SkullMeta)item.getItemMeta()).hasOwner()) {
                        this.set(path + ".head-owner", Objects.requireNonNull(skullMeta.getOwningPlayer()).getName());
                    }
                }
                catch (NoSuchFieldError e) {
                    SkullMeta skullMeta;
                    if (!item.getType().toString().equals("LEGACY_SKULL_ITEM") || !(skullMeta = (SkullMeta)item.getItemMeta()).hasOwner()) break block15;
                    this.set(path + ".head-owner", Objects.requireNonNull(skullMeta.getOwningPlayer()).getName());
                }
            }
        }
    }

    public void sendMessage(CommandSender commandSender, String path) {
        this.sendMessage(commandSender, path, new String[0][]);
    }

    /*
     * WARNING - void declaration
     */
    public void sendMessage(CommandSender commandSender, String path, String[][] replacements) {
        List<Object> messages = new ArrayList();
        if (this.isList(path)) {
            messages = this.getStringList(path, replacements);
        } else if (this.isString(path)) {
            messages.add(this.getString(path, replacements));
        }
        for (String string : messages) {
            void var6_13;
            void var6_10;
            for (String text : this.replacements.keySet()) {
                void var6_8;
                String string2 = var6_8.replaceAll("%" + text + "%", this.replacements.get(text));
            }
            for (String text : globalReplacements.keySet()) {
                String string3 = var6_10.replaceAll("%" + text + "%", globalReplacements.get(text));
            }
            if (commandSender instanceof Player && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                String string4 = PlaceholderAPI.setPlaceholders((Player)((Player)commandSender), (String)var6_10);
            }
            String string5 = ChatColor.translateAlternateColorCodes((char)'&', (String)var6_13);
            commandSender.sendMessage(string5);
        }
    }

    public static void sendSimpleMessage(CommandSender commandSender, Object message) {
        Yaml.sendSimpleMessage(commandSender, message, new String[0][]);
    }

    public static void sendSimpleMessage(CommandSender commandSender, Object message, String[][] replacements) {
        List<String> messages = new ArrayList();
        if (message.getClass().getSimpleName().equals("ArrayList")) {
            messages = (List)message;
        } else if (message.getClass().getSimpleName().equals("String")) {
            messages.add((String)message);
        }
        for (String m : messages) {
            for (String[] replacement : replacements) {
                m = m.replaceAll(replacement[0], replacement[1]);
            }
            for (String text : globalReplacements.keySet()) {
                m = m.replaceAll("%" + text + "%", globalReplacements.get(text));
            }
            if (commandSender instanceof Player && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                m = PlaceholderAPI.setPlaceholders((Player)((Player)commandSender), (String)m);
            }
            m = ChatColor.translateAlternateColorCodes((char)'&', (String)m);
            commandSender.sendMessage(m);
        }
    }

    public static ItemStack replace(ItemStack itemStack) {
        return Yaml.replace(itemStack, null, new String[0][]);
    }

    public static ItemStack replace(ItemStack itemStack, Player player) {
        return Yaml.replace(itemStack, player, new String[0][]);
    }

    public static ItemStack replace(ItemStack itemStack, String[][] replacements) {
        return Yaml.replace(itemStack, null, replacements);
    }

    public static ItemStack replace(ItemStack itemStack, Player player, String[][] replacements) {
        ItemMeta meta;
        ItemStack item;
        block16: {
            item = new ItemStack(itemStack);
            meta = item.getItemMeta();
            if (meta != null) {
                if (meta.hasDisplayName()) {
                    String displayName = meta.getDisplayName();
                    for (String[] values : replacements) {
                        displayName = displayName.replaceAll(values[0], values[1]);
                    }
                    if (player != null && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                        displayName = PlaceholderAPI.setPlaceholders((Player)player, (String)displayName);
                    }
                    displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)displayName);
                    meta.setDisplayName(displayName);
                }
                if (meta.hasLore()) {
                    List lore = meta.getLore();
                    ArrayList<String> newLore = new ArrayList<String>();
                    if (lore != null) {
                        for (String line : lore) {
                            String[][] stringArray = replacements;
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String[] values = stringArray[i];
                                line = line.replaceAll(values[0], values[1]);
                            }
                            if (player != null && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                                line = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                            }
                            line = ChatColor.translateAlternateColorCodes((char)'&', (String)line);
                            newLore.add(line);
                        }
                        meta.setLore(newLore);
                    }
                }
                try {
                    if (item.getType().toString().equals("PLAYER_HEAD")) {
                        SkullMeta skullMeta = (SkullMeta)meta;
                        String skullOwner = skullMeta.getOwner();
                        for (String[] values : replacements) {
                            skullOwner = skullOwner.replaceAll(values[0], values[1]);
                        }
                        if (player != null && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                            skullOwner = PlaceholderAPI.setPlaceholders((Player)player, (String)skullOwner);
                        }
                        skullMeta.setOwner(skullOwner);
                    }
                }
                catch (Exception e) {
                    if (!item.getType().toString().equals("LEGACY_SKULL_ITEM")) break block16;
                    SkullMeta skullMeta = (SkullMeta)meta;
                    String skullOwner = skullMeta.getOwner();
                    for (String[] values : replacements) {
                        skullOwner = skullOwner.replaceAll(values[0], values[1]);
                    }
                    if (player != null && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                        skullOwner = PlaceholderAPI.setPlaceholders((Player)player, (String)skullOwner);
                    }
                    skullMeta.setOwner(skullOwner);
                }
            }
        }
        item.setItemMeta(meta);
        return item;
    }
}

