/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.block;

import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import net.coreprotect.listener.player.ProjectileLaunchListener;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.Util;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.inventory.ItemStack;

public final class BlockIgniteListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockIgnite(BlockIgniteEvent event) {
        World world = event.getBlock().getWorld();
        if (!event.isCancelled() && Config.getConfig((World)world).BLOCK_IGNITE) {
            Block block = event.getBlock();
            if (block == null) {
                return;
            }
            Material blockType = block.getType();
            Material blockIgnited = Material.FIRE;
            Material blockBelow = Material.AIR;
            Location scanLocation = block.getLocation().clone();
            if (scanLocation.getY() > (double)BukkitAdapter.ADAPTER.getMinHeight(world)) {
                scanLocation.setY(scanLocation.getY() - 1.0);
                blockBelow = scanLocation.getBlock().getType();
                if (BlockGroup.SOUL_BLOCKS.contains(blockBelow)) {
                    for (Material fire : BlockGroup.FIRE) {
                        if (fire == blockIgnited) continue;
                        blockIgnited = fire;
                        break;
                    }
                } else if (event.getCause() == BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL && blockBelow == Material.AIR) {
                    return;
                }
            }
            BlockState replacedBlock = null;
            BlockData forceBlockData = block.getBlockData();
            if (BlockGroup.LIGHTABLES.contains(blockType)) {
                blockIgnited = blockType;
                replacedBlock = block.getState();
                if (forceBlockData instanceof Lightable) {
                    Lightable lightable = (Lightable)forceBlockData;
                    lightable.setLit(true);
                }
            }
            if (event.getPlayer() == null) {
                if (event.getCause() == BlockIgniteEvent.IgniteCause.FIREBALL && (blockType == Material.AIR || blockType == Material.CAVE_AIR) && BlockGroup.LIGHTABLES.contains(blockBelow)) {
                    return;
                }
                if (blockIgnited == Material.FIRE && event.getCause() == BlockIgniteEvent.IgniteCause.LAVA && event.getIgnitingBlock() != null) {
                    boolean burnableBlock = false;
                    block9: for (BlockFace face : BlockFace.values()) {
                        Location blockLocation = block.getLocation();
                        scanLocation.setX(blockLocation.getX());
                        scanLocation.setY(blockLocation.getY());
                        scanLocation.setZ(blockLocation.getZ());
                        switch (face) {
                            case NORTH: {
                                scanLocation.setZ(scanLocation.getZ() - 1.0);
                                break;
                            }
                            case SOUTH: {
                                scanLocation.setZ(scanLocation.getZ() + 1.0);
                                break;
                            }
                            case WEST: {
                                scanLocation.setX(scanLocation.getX() - 1.0);
                                break;
                            }
                            case EAST: {
                                scanLocation.setX(scanLocation.getX() + 1.0);
                                break;
                            }
                            case DOWN: {
                                scanLocation.setY(scanLocation.getY() - 1.0);
                                break;
                            }
                            case UP: {
                                scanLocation.setY(scanLocation.getY() + 1.0);
                                break;
                            }
                            default: {
                                continue block9;
                            }
                        }
                        if (scanLocation.getY() < (double)BukkitAdapter.ADAPTER.getMinHeight(world) || scanLocation.getY() >= (double)world.getMaxHeight() || !scanLocation.getBlock().getType().isBurnable()) continue;
                        burnableBlock = true;
                        break;
                    }
                    if (!burnableBlock) {
                        return;
                    }
                }
                Queue.queueBlockPlace("#fire", block.getState(), block.getType(), replacedBlock, blockIgnited, -1, 0, forceBlockData.getAsString());
            } else {
                if (event.getCause() == BlockIgniteEvent.IgniteCause.FIREBALL) {
                    ProjectileLaunchListener.playerLaunchProjectile(event.getPlayer().getLocation(), event.getPlayer().getName(), new ItemStack(Material.FIRE_CHARGE), 1, -1, 1, 6);
                }
                Player player = event.getPlayer();
                Queue.queueBlockPlace(player.getName(), block.getState(), block.getType(), replacedBlock, blockIgnited, -1, 0, forceBlockData.getAsString());
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                int world_id = Util.getWorldId(block.getWorld().getName());
                CacheHandler.lookupCache.put(block.getX() + "." + block.getY() + "." + block.getZ() + "." + world_id, new Object[]{unixtimestamp, player.getName(), block.getType()});
            }
        }
    }
}

