/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.player;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public final class CraftItemListener
extends Queue
implements Listener {
    protected static void logCraftedItem(Location location, String user, ItemStack itemStack, int action) {
        List list;
        if (!Config.getConfig((World)location.getWorld()).ITEM_TRANSACTIONS || itemStack == null) {
            return;
        }
        String loggingItemId = user.toLowerCase(Locale.ROOT) + "." + location.getBlockX() + "." + location.getBlockY() + "." + location.getBlockZ();
        int itemId = CraftItemListener.getItemId(loggingItemId);
        if (action == 12) {
            list = ConfigHandler.itemsBuy.getOrDefault(loggingItemId, new ArrayList());
            list.add(itemStack);
            ConfigHandler.itemsBuy.put(loggingItemId, list);
        } else if (action == 11) {
            list = ConfigHandler.itemsSell.getOrDefault(loggingItemId, new ArrayList());
            list.add(itemStack);
            ConfigHandler.itemsSell.put(loggingItemId, list);
        } else if (action == 10) {
            list = ConfigHandler.itemsCreate.getOrDefault(loggingItemId, new ArrayList());
            list.add(itemStack);
            ConfigHandler.itemsCreate.put(loggingItemId, list);
        } else {
            list = ConfigHandler.itemsDestroy.getOrDefault(loggingItemId, new ArrayList());
            list.add(itemStack);
            ConfigHandler.itemsDestroy.put(loggingItemId, list);
        }
        int time = (int)(System.currentTimeMillis() / 1000L) + 1;
        Queue.queueItemTransaction(user, location.clone(), time, 0, itemId);
    }

    protected static void playerCraftItem(InventoryClickEvent event, boolean isTrade) {
        if (event.getResult() == Event.Result.DENY || event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        HumanEntity player = event.getWhoClicked();
        if (event.getClick() == ClickType.NUMBER_KEY && player.getInventory().getItem(event.getHotbarButton()) != null) {
            return;
        }
        if ((event.getClick() == ClickType.DROP || event.getClick() == ClickType.CONTROL_DROP) && event.getCursor().getType() != Material.AIR) {
            return;
        }
        Inventory bottomInventory = event.getView().getBottomInventory();
        if (bottomInventory.getType() != InventoryType.PLAYER) {
            return;
        }
        Recipe recipe = null;
        if (!isTrade && event instanceof CraftItemEvent) {
            recipe = ((CraftItemEvent)event).getRecipe();
        } else if (isTrade && event.getInventory() instanceof MerchantInventory) {
            recipe = ((MerchantInventory)event.getInventory()).getSelectedRecipe();
        }
        if (recipe == null) {
            return;
        }
        ItemStack addItem = recipe.getResult().clone();
        int amount = addItem.getAmount();
        if (amount == 0) {
            return;
        }
        int amountMultiplier = 1;
        if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
            int newMultiplier = Integer.MIN_VALUE;
            for (ItemStack item : event.getInventory().getContents()) {
                if (item == null || item.getType() == Material.AIR || item.equals((Object)recipe.getResult())) continue;
                if (isTrade) {
                    int merchantUsesLeft;
                    int merchantAmount = newMultiplier;
                    MerchantRecipe merchantRecipe = (MerchantRecipe)recipe;
                    for (ItemStack ingredient : merchantRecipe.getIngredients()) {
                        if (!ingredient.isSimilar(item)) continue;
                        ItemStack adjusted = BukkitAdapter.ADAPTER.adjustIngredient(merchantRecipe, ingredient);
                        if (adjusted == null) {
                            return;
                        }
                        merchantAmount = item.getAmount() / adjusted.getAmount();
                        break;
                    }
                    if ((merchantUsesLeft = merchantRecipe.getMaxUses() - merchantRecipe.getUses()) < merchantAmount) {
                        merchantAmount = merchantUsesLeft;
                    }
                    if (newMultiplier != Integer.MIN_VALUE && merchantAmount >= newMultiplier) continue;
                    newMultiplier = merchantAmount;
                    continue;
                }
                if (newMultiplier != Integer.MIN_VALUE && item.getAmount() >= newMultiplier) continue;
                newMultiplier = item.getAmount();
            }
            amountMultiplier = newMultiplier == Integer.MIN_VALUE ? 1 : newMultiplier;
            int addAmount = amount * amountMultiplier;
            Inventory virtualInventory = Bukkit.createInventory(null, (int)36);
            virtualInventory.setStorageContents(bottomInventory.getStorageContents());
            addItem.setAmount(1);
            int addSuccess = 0;
            for (int i = 0; i < addAmount && virtualInventory.addItem(new ItemStack[]{addItem}).isEmpty(); ++i) {
                ++addSuccess;
            }
            if (addSuccess < addAmount) {
                addAmount = (int)(Math.ceil((double)addSuccess / (double)amount) * (double)amount);
                amountMultiplier = addAmount / amount;
            }
            virtualInventory.clear();
            addItem.setAmount(addAmount);
        }
        ArrayList oldItems = new ArrayList();
        if (recipe instanceof ShapelessRecipe) {
            oldItems.addAll(((ShapelessRecipe)recipe).getIngredientList());
        } else if (recipe instanceof ShapedRecipe) {
            oldItems.addAll(((ShapedRecipe)recipe).getIngredientMap().values());
        } else if (recipe instanceof MerchantRecipe) {
            oldItems.addAll(((MerchantRecipe)recipe).getIngredients());
        }
        if (addItem.getAmount() > 0) {
            Location location = isTrade || event.getInventory().getLocation() == null ? player.getLocation() : event.getInventory().getLocation();
            for (ItemStack oldItem : oldItems) {
                ItemStack removedItem;
                if (oldItem == null || oldItem.getType() == Material.AIR) continue;
                ItemStack itemStack = removedItem = isTrade ? BukkitAdapter.ADAPTER.adjustIngredient((MerchantRecipe)recipe, oldItem) : oldItem.clone();
                if (removedItem == null) {
                    return;
                }
                removedItem.setAmount(removedItem.getAmount() * amountMultiplier);
                CraftItemListener.logCraftedItem(location, player.getName(), removedItem, isTrade ? 11 : 9);
            }
            CraftItemListener.logCraftedItem(location, player.getName(), addItem, isTrade ? 12 : 10);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    protected void onCraftItem(CraftItemEvent event) {
        CraftItemListener.playerCraftItem((InventoryClickEvent)event, false);
    }
}

