/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.chunkloader.chunk;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kayteam.chunkloader.ChunkLoader;
import org.kayteam.chunkloader.util.ChunkUtil;
import org.kayteam.storageapi.storage.Yaml;

public class ChunkManager {
    public boolean chunkLoad;
    public boolean chunkLoadLogs;
    private boolean isPaper = false;
    public boolean updateChecker = true;
    private List<Chunk> chunkList = new ArrayList<Chunk>();
    private boolean worldEdit = false;

    public void checkWorldEdit() {
        if (Bukkit.getPluginManager().isPluginEnabled("WorldEdit")) {
            this.worldEdit = true;
        }
    }

    public boolean isWorldEdit() {
        return this.worldEdit;
    }

    public boolean isPaper() {
        return this.isPaper;
    }

    public void setPaperState(boolean state) {
        this.isPaper = state;
        if (state) {
            Yaml.sendSimpleMessage((CommandSender)ChunkLoader.getInstance().getServer().getConsoleSender(), "&2Chunk&aLoader &7>> &f&fEnabled Paper version.");
        } else {
            Yaml.sendSimpleMessage((CommandSender)ChunkLoader.getInstance().getServer().getConsoleSender(), "&2Chunk&aLoader &7>> &f&fEnabled Spigot version.");
        }
    }

    public boolean isChunkLoad() {
        return this.chunkLoad;
    }

    public boolean isChunkLoadLogs() {
        return this.chunkLoadLogs;
    }

    public void setChunkLoadLogs(boolean state) {
        ChunkLoader.config.set("log-chunk-load", state);
        ChunkLoader.config.save();
        this.chunkLoadLogs = state;
    }

    public void loadChunk(final Chunk chunk) {
        if (ChunkLoader.getInstance().getServer().getWorlds().contains(chunk.getWorld())) {
            Bukkit.getScheduler().runTaskLater((Plugin)ChunkLoader.getInstance(), new Runnable(){

                @Override
                public void run() {
                    try {
                        chunk.getWorld().setChunkForceLoaded(chunk.getX(), chunk.getZ(), true);
                    }
                    catch (NoSuchMethodError e) {
                        chunk.getWorld().loadChunk(chunk.getX(), chunk.getZ());
                    }
                }
            }, 1L);
            if (this.isChunkLoadLogs()) {
                Yaml.sendSimpleMessage((CommandSender)ChunkLoader.getInstance().getServer().getConsoleSender(), ChunkLoader.messages.getString("logs.load"), new String[][]{{"%chunk%", ChunkUtil.toString(chunk)}});
            }
        }
    }

    public void enableChunkLoad() {
        this.loadChunkList();
        ChunkLoader.config.set("chunk-load", true);
        ChunkLoader.config.save();
        this.chunkLoad = true;
    }

    public void disableChunkLoad() {
        ChunkLoader.config.set("chunk-load", false);
        ChunkLoader.config.save();
        this.chunkLoad = false;
        for (Chunk chunk : this.chunkList) {
            this.unloadChunk(chunk);
        }
    }

    public void unloadChunk(Chunk chunk) {
        try {
            chunk.getWorld().setChunkForceLoaded(chunk.getX(), chunk.getZ(), false);
        }
        catch (NoSuchMethodError e) {
            chunk.getWorld().unloadChunk(chunk);
        }
        if (this.isChunkLoadLogs()) {
            Yaml.sendSimpleMessage((CommandSender)ChunkLoader.getInstance().getServer().getConsoleSender(), ChunkLoader.messages.getString("logs.unload"), new String[][]{{"%chunk%", ChunkUtil.toString(chunk)}});
        }
    }

    public void deleteChunk(Chunk chunk, Player player) {
        World chunkLocationWorld = chunk.getWorld();
        int chunkLocationX = chunk.getX();
        int chunkLocationZ = chunk.getZ();
        String chunkCoords = "X: " + chunkLocationX + "; Z:" + chunkLocationZ;
        if (this.chunkList.contains(chunk)) {
            this.getChunkList().remove(chunk);
            List<String> chunkStringList = ChunkUtil.toStringList(this.getChunkList());
            ChunkLoader.data.set("chunks-list", chunkStringList);
            ChunkLoader.data.save();
            this.unloadChunk(chunk);
            ChunkLoader.messages.sendMessage((CommandSender)player, "removechunk.correct", new String[][]{{"%chunk_coords%", chunkCoords}});
        } else {
            ChunkLoader.messages.sendMessage((CommandSender)player, "removechunk.inexist", new String[][]{{"%chunk_coords%", chunkCoords}});
        }
        this.loadChunkList();
    }

    public void loadChunkList() {
        this.chunkList.clear();
        List<String> chunks = ChunkLoader.data.getStringList("chunks-list");
        for (String chunkString : chunks) {
            Chunk chunk = ChunkUtil.toChunk(chunkString);
            if (!ChunkLoader.getInstance().getServer().getWorlds().contains(chunk.getWorld())) continue;
            this.getChunkList().add(chunk);
            this.loadChunk(chunk);
        }
    }

    public List<Chunk> getChunkList() {
        return this.chunkList;
    }

    public void addChunk(Chunk chunk) {
        this.getChunkList().add(chunk);
        ChunkLoader.data.set("chunks-list", ChunkUtil.toStringList(this.getChunkList()));
        ChunkLoader.data.save();
        this.loadChunk(chunk);
    }

    public boolean isUpdateChecker() {
        return this.updateChecker;
    }
}

