/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.chunkloader.inventories;

import java.util.List;
import org.bukkit.Chunk;
import org.kayteam.chunkloader.ChunkLoader;
import org.kayteam.chunkloader.commands.Command_TP;
import org.kayteam.chunkloader.inventories.MainMenuInventory;
import org.kayteam.inventoryapi.InventoryBuilder;
import org.kayteam.storageapi.storage.YML;
import org.kayteam.storageapi.storage.Yaml;

public class ChunksListInventory
extends InventoryBuilder {
    public ChunksListInventory(int page) {
        super(ChunkLoader.config.getString("menu.chunk-list.title"), 6);
        YML config = ChunkLoader.config;
        this.fillItem(() -> config.getItemStack("menu.general-options.items.fill"), new int[]{6});
        this.addItem(48, () -> config.getItemStack("menu.general-options.items.back"));
        this.addLeftAction(48, (player1, i) -> ChunkLoader.getInventoryManager().openInventory(player1, new MainMenuInventory()));
        this.addItem(49, () -> config.getItemStack("menu.general-options.items.close"));
        this.addLeftAction(49, (player1, i) -> player1.closeInventory());
        List<Chunk> chunks = ChunkLoader.getChunkManager().getChunkList();
        for (int i2 = 0; i2 < 45; ++i2) {
            int index = page * 45 - 45 + i2;
            if (index >= chunks.size()) continue;
            this.addItem(i2, () -> Yaml.replace(config.getItemStack("menu.chunk-list.items.listed"), new String[][]{{"%index%", String.valueOf(index)}, {"%coords_x%", String.valueOf(((Chunk)chunks.get(index)).getX())}, {"%coords_z%", String.valueOf(((Chunk)chunks.get(index)).getZ())}, {"%coords_world%", ((Chunk)chunks.get(index)).getWorld().getName()}}));
            this.addLeftAction(i2, (player1, slot) -> {
                player1.closeInventory();
                new Command_TP().chunkTeleport(player1, index);
            });
            this.addRightAction(i2, (player1, slot) -> {
                ChunkLoader.getChunkManager().deleteChunk((Chunk)chunks.get(index), player1);
                player1.closeInventory();
                ChunkLoader.getInventoryManager().openInventory(player1, new ChunksListInventory(page));
            });
        }
        if (page > 1) {
            this.addItem(45, () -> config.getItemStack("menu.general-options.items.previous-page"));
            this.addLeftAction(45, (player1, slot) -> ChunkLoader.getInventoryManager().openInventory(player1, new ChunksListInventory(page - 1)));
        }
        if (chunks.size() > page * 45) {
            this.addItem(53, () -> config.getItemStack("menu.general-options.items.next-page"));
            this.addLeftAction(53, (player1, slot) -> ChunkLoader.getInventoryManager().openInventory(player1, new ChunksListInventory(page + 1)));
        }
    }
}

