/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.chunkloader.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin javaPlugin;
    private int resourceId;
    private URL resourceURL;
    private String currentVersionString;
    private String latestVersionString;
    private UpdateCheckResult updateCheckResult;

    public UpdateChecker(JavaPlugin javaPlugin, int resourceId) {
        int latestVersion;
        this.javaPlugin = javaPlugin;
        try {
            this.resourceId = resourceId;
            this.resourceURL = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resourceId);
        }
        catch (Exception exception) {
            return;
        }
        this.currentVersionString = javaPlugin.getDescription().getVersion();
        this.latestVersionString = this.getLatestVersion();
        if (this.latestVersionString == null) {
            this.updateCheckResult = UpdateCheckResult.NO_RESULT;
            return;
        }
        int currentVersion = Integer.parseInt(this.currentVersionString.replace("v", "").replace(".", ""));
        this.updateCheckResult = currentVersion < (latestVersion = Integer.parseInt(this.getLatestVersion().replace("v", "").replace(".", ""))) ? UpdateCheckResult.OUT_DATED : (currentVersion == latestVersion ? UpdateCheckResult.UP_TO_DATE : UpdateCheckResult.UNRELEASED);
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public String getResourceURL() {
        return "https://www.spigotmc.org/resources/" + this.resourceId;
    }

    public String getCurrentVersionString() {
        return this.currentVersionString;
    }

    public String getLatestVersionString() {
        return this.latestVersionString;
    }

    public UpdateCheckResult getUpdateCheckResult() {
        return this.updateCheckResult;
    }

    public String getLatestVersion() {
        try {
            URLConnection urlConnection = this.resourceURL.openConnection();
            return new BufferedReader(new InputStreamReader(urlConnection.getInputStream())).readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void sendOutDatedMessage(CommandSender commandSender) {
        ArrayList<String> message = new ArrayList<String>();
        message.add("");
        message.add("&f>>");
        message.add("&f>> &6The plugin " + this.javaPlugin.getDescription().getName() + "is outdated.");
        message.add("&f>> &6Current Version &f" + this.javaPlugin.getDescription().getVersion());
        message.add("&f>>");
        message.add("&f>> &6Latest Version &f" + this.latestVersionString);
        message.add("&f>> &6Download latest version here");
        message.add("&f>> &f" + this.getResourceURL());
        message.add("&f>>");
        message.add("");
        for (String line : message) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
    }

    public static enum UpdateCheckResult {
        NO_RESULT,
        OUT_DATED,
        UP_TO_DATE,
        UNRELEASED;

    }
}

